% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdjustableModels.R
\name{calibrate_ER.nonsquare}
\alias{calibrate_ER.nonsquare}
\title{Calibrate ER model to a given density with a nonsquare matrix}
\usage{
calibrate_ER.nonsquare(
  l,
  a,
  targetdensity,
  L_fixed = NA,
  nsamples_calib = 100,
  thin_calib = 100
)
}
\arguments{
\item{l}{row sums of matrix to be reconstructed}

\item{a}{column sum of matrix to be reconstructed}

\item{targetdensity}{desired proportion of reconstructed entries to be positive}

\item{L_fixed}{Matrix containing known values of L, where NA signifies that
an element is not known. If \code{L_fixed} equates to \code{NA} (the
default) then no values are assumed to be known.}

\item{nsamples_calib}{number of matrices to generate during calibration.}

\item{thin_calib}{amount of thinning to use during calibration}
}
\value{
Model that can be used to generate the desired samples using \code{\link{sample_HierarchicalModel}}.
}
\description{
The model is an Erdos-Renyi model for the existence of links (a
link exists independently of other links with a fixed probability)
and the weight of each existing link follows an exponential
distribution with a fixed rate parameter. This function chooses the
two parameters such that the density of the network (the average
proportion of existing links) is a certain desired value. This
function does not set diagonal values to 0.
}
\examples{
## first generate a true network
nrow <- 10 # size of network
ncol <- 8 # size of network
p <- 0.45
lambda <- 0.1
L <- matrix(nrow=nrow,rbinom(nrow*ncol,prob=p,size=1)*rexp(nrow*ncol,rate=lambda))

# then reconstruct with a target density of 0.55
model <- calibrate_ER.nonsquare(l=rowSums(L),a=colSums(L),
                      targetdensity=0.55,nsamples_calib=10)
Lsamp <- sample_HierarchicalModel(l=rowSums(L),a=colSums(L),model=model,
                                    nsamples=10,thin=1e2)
# check row sums
rowSums(L)
rowSums(Lsamp$L[[10]])
# check calibration
mean(Lsamp$L[[10]]>0)

# now an example with some fixed entries
L_fixed <- L
L_fixed[1:(nrow/2),] <- NA
# then reconstruct with a target density of 0.9
model <- calibrate_ER.nonsquare(l=rowSums(L),a=colSums(L),L_fixed=L_fixed,
                              targetdensity=0.9,nsamples_calib=10)
Lsamp <- sample_HierarchicalModel(l=rowSums(L),a=colSums(L),L_fixed=L_fixed,
                                  model=model,nsamples=10,thin=1e2)
mean(Lsamp$L[[10]][-(1:(nrow/2)),]>0) # known entries
mean(Lsamp$L[[10]][(1:(nrow/2)),]>0)  #reconstructed entries
}
