% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_performance_single.R
\name{plot_performance_single}
\alias{plot_performance_single}
\title{plot_performance_single}
\usage{
plot_performance_single(
  data,
  triagelevel_correct,
  triagelevel_advice,
  order_triagelevel,
  vector_not_entered
)
}
\arguments{
\item{data}{A dataframe}

\item{triagelevel_correct}{A string indicating the column name storing the correct triage solutions}

\item{triagelevel_advice}{A string indicating the column name storing the recommendation of a symptom checker for a case}

\item{order_triagelevel}{A vector indicating the order of triage levels. The triage level with highest urgency should be the first value and the triage level with lowest urgency the last value.}

\item{vector_not_entered}{A vector indicating the values in which missing values are coded (e.g., as NA or a specified value such as -99)}
}
\value{
A ggplot object visualizing all performance metrics for one symptom checker
}
\description{
Plots all performance metrics for one symptom checker
}
\examples{
data(symptomcheckRdata)
performance_plot <- plot_performance_single(
  data = symptomcheckRdata,
  triagelevel_correct = "Goldstandard_solution",
  triagelevel_advice = "Triage_advice_from_app",
  order_triagelevel = c("Emergency", "Non-Emergency", "Self-care"),
  vector_not_entered = c(NA)
  )

}
