% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ccs.R
\name{get_ccs}
\alias{get_ccs}
\title{get_ccs}
\usage{
get_ccs(data, correct, vignettes, apps)
}
\arguments{
\item{data}{A dataframe}

\item{correct}{A string indicating the column name storing if the symptom checker solved the case (TRUE or FALSE)}

\item{vignettes}{A string indicating the column name storing the vignette or vignette number}

\item{apps}{A string indicating the column name storing the app names}
}
\value{
A data frame object containing the capability comparison score for each symptom checker.
}
\description{
Calculates the Capability Comparison Score (CCS) for each symptom checker
}
\examples{
data(symptomcheckRdata)
ccs <- get_ccs(
  data = symptomcheckRdata,
  correct = "Correct_Triage_Advice_provided_from_app",
  vignettes = "Vignette_id",
  apps = "App_name"
  )
}
