% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{nsd}
\alias{nsd}
\title{Net Squared Displacement}
\usage{
nsd(x, y, geo = FALSE)
}
\arguments{
\item{x}{A vector of x (or longitude) coordinates corresponding to a single 
trajectory.}

\item{y}{A vector of y (or latitude) coordinates corresponding to a single 
trajectory.}

\item{geo}{A logical value indicating whether the locations are defined by 
geographic coordinates (pairs of longitude/latitude values). Default: FALSE.}
}
\value{
A vector of the same length as x and y corresponding to the net 
 squared distances between each location and the first location of the 
 trajectory.
}
\description{
Given a set of locations defining a trajectory, this function 
 computes the net squared displacement of the trajectory, that is the squared 
 distances between each location and the first location of the trajectory
}
\examples{
x <- rnorm(25)
y <- rnorm(25, sd = 3)
nsd(x, y)

}
\seealso{
\code{\link{linear_dist}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
