% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_uni_con.R
\name{surv_uni_con}
\alias{surv_uni_con}
\title{Modify the Survival Output for a Continuous Variable.}
\usage{
surv_uni_con(dat, stime, sevent, svar, report_index = FALSE)
}
\arguments{
\item{dat}{a data.frame.}

\item{stime}{the duration of follow-up time in months.}

\item{sevent}{the status indicator, which is generally 0 = alive, 1 = dead.}

\item{svar}{a variable name.}

\item{report_index}{logical value indicating if to report the show AIC and C index.}
}
\value{
a tibble of survival results.
}
\description{
This function generates a table with the general survival analysis results, including the number of total patients, the number of events, the P value, the AIC, and the C index. This function just modifies the output table's format.
}
\examples{
Dat <- survival::lung
surv_uni_con(Dat, "time", "status", "age",report_index = TRUE)
}
