% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survmixture_f.R
\name{survmixture_f}
\alias{survmixture_f}
\title{Mixture survival function}
\usage{
survmixture_f(t, ascale_r, ascale_nr, bshape = 1, p)
}
\arguments{
\item{t}{time at which the survival distribution is evaluated}

\item{ascale_r}{scale parameter for the Weibull distribution   for responders}

\item{ascale_nr}{scale parameter for the Weibull distribution  for non-responders}

\item{bshape}{shape parameter for the Weibull distribution}

\item{p}{event rate for the response}
}
\value{
This function returns the survival function evaluated at t based on a  mixture model of  responders and non-responders.
}
\description{
The function `survmixture_f` computes the survival distribution as a mixture of  responders and non-responders. The responders and non-responders distributions are assumed to be Weibull distributions.
}
\examples{
survmixture_f(t=0.2,ascale_r=8,ascale_nr=5.6,p=0.2)
}
\references{
Design of phase III trials with long-term survival outcomes based on short-term binary results. Marta Bofill Roig, Yu Shen, Guadalupe Gomez Melis. 	arXiv:2008.12887
}
\author{
Marta Bofill Roig.
}
