% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.coxph_mpl_dc.R
\name{coef.coxph_mpl_dc}
\alias{coef.coxph_mpl_dc}
\title{Extract regression coefficients of a coxph_mpl_dc Object}
\usage{
\method{coef}{coxph_mpl_dc}(object, parameter, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{\link{coxph_mpl_dc}}}

\item{parameter}{the set of parameters of interest.  Indicate \code{parameters="beta"} for the regression parameter of beta
and \code{parameters="phi"} for the regression parameter of phi}

\item{...}{other arguments}
}
\value{
\item{est}{a matrix of coefficients with standard errors, z-statistics and corresponding p-values}
}
\description{
Extract the matrix of regression coefficients with their corresponding standard errors,
\eqn{z}-statistics and \eqn{p}-values of the model part of interest of a \code{coxph_mpl_dc} object
}
\details{
When the input is of class \code{coxph_mpl_dc} and \code{parameters=="beta"},
the matrix of beta estimates with corresponding standar errors, \eqn{z}-statistics and \eqn{p}-values are reported. When the input is of class \code{coxph_mpl_dc} and \code{parameters=="phi"},
the matrix of phi estimates with corresponding standar errors, \eqn{z}-statistics and \eqn{p}-values are reported.
}
\examples{
\donttest{

 ##-- Copula types
 copula3 <- 'frank'

##-- A real example
##-- One dataset from Prospective Research in Memory Clinics (PRIME) study
##-- Refer to article Brodaty et al (2014),
##   the predictors of institutionalization of dementia patients over 3-year study period

data(PRIME)

surv<-as.matrix(PRIME[,1:3]) #time, event and dependent censoring indicators
cova<-as.matrix(PRIME[, -c(1:3)]) #covariates
colMeans(surv[,2:3])  #the proportions of event and dependent censoring

n<-dim(PRIME)[1];print(n)
p<-dim(PRIME)[2]-3;print(p)
names(PRIME)

##--MPL estimate Cox proportional hazard model for institutionalization under independent censoring
control <- coxph_mpl_dc.control(ordSp = 4,
                                binCount = 200, tie = 'Yes',
                                tau = 0.5, copula = copula3,
                                pent = 'penalty_mspl', smpart = 'REML',
                                penc = 'penalty_mspl', smparc = 'REML',
                                cat.smpar = 'No' )

coxMPLests_tau <- coxph_mpl_dc(surv=surv, cova=cova, control=control, )
MPL_beta<-coef(object = coxMPLests_tau, parameter = "beta",)
MPL_phi<-coef(object = coxMPLests_tau, parameter = "phi",)

}

}
\references{
Brodaty H, Connors M, Xu J, Woodward M, Ames D. (2014). \emph{"Predictors of institutionalization
in dementia: a three year longitudinal study"}. Journal of Alzheimers Disease 40, 221-226.

Xu J, Ma J, Connors MH, Brodaty H. (2018). \emph{"Proportional hazard model estimation under dependent censoring using copulas and penalized likelihood"}.
Statistics in Medicine 37, 2238–2251.
}
\seealso{
\code{\link{plot.coxph_mpl_dc}}, \code{\link{coxph_mpl_dc.control}}, \code{\link{coxph_mpl_dc}}
}
\author{
Jing Xu, Jun Ma, Thomas Fung
}
