% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survCoxPH.R
\name{survcox_train}
\alias{survcox_train}
\title{Trains CoxPH using survival package, or trains CoxLasso (cv.glmnet, lambda.min),
and then re-trains survival:coxph on non-zero predictors}
\usage{
survcox_train(
  df_train,
  predict.factors,
  fixed_time = NaN,
  useCoxLasso = FALSE,
  retrain_cox = FALSE,
  inner_cv = 5
)
}
\arguments{
\item{df_train}{data, "time" and "event" should describe survival outcome}

\item{predict.factors}{list of the column names to be used as predictors}

\item{fixed_time}{target time, NaN by default; needed here only to re-align with other methods}

\item{useCoxLasso}{TRUE or FALSE}

\item{retrain_cox}{if useCoxLasso is TRUE, whether to re-train coxph on non-zero predictors, FALSE by default}

\item{inner_cv}{k in k-fold CV for training lambda for Cox Lasso, only used for useCoxLasso = TRUE}
}
\value{
fitted CoxPH or CoxLasso model
}
\description{
Trains CoxPH using survival package, or trains CoxLasso (cv.glmnet, lambda.min),
and then re-trains survival:coxph on non-zero predictors
}
