
make_dictionary<- function(file, mapping = NULL){

  if(!is.character(file))stop("file must be a character-vector")

  if(is.null(mapping)){
    path  <- system.file("extdata", "etcsl_mapping.txt", package = "sumer")
    mapping <- read.csv2(path, sep=";", na.strings="")
  }

  df <- read_translated_text(file, mapping)
  df <- beautify_translations(df)
  df <- convert_to_dictionary(df, mapping)

  return(df)
}

