% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SF.R
\name{SF}
\alias{SF}
\title{Select a method from PC, SIR and DR to do point prediction}
\usage{
SF(
  y,
  X,
  newX = NULL,
  K = "default",
  L = 1,
  method = "SIR.LM",
  hyperparameter = list()
)
}
\arguments{
\item{y}{Response, T by 1 matrix}

\item{X}{Predictors, p by T matrix}

\item{newX}{New predictors, a vector contains p entries (or \code{NULL})}

\item{K}{The number of common factors (default = obtained by
\code{\link{getK}})}

\item{L}{The number of predictive indices, L is required to be no greater than
K (default = 1)}

\item{method}{Select one from \code{PC}, \code{SIR.LM}, \code{SIR.LLM}
and \code{DR} to do point prediction (default = \code{SIR.LM})}

\item{hyperparameter}{A list of parameters for the corresponding method
\describe{
\item{For \code{SIR.LM} and \code{SIR.LLM}:}{arguments \code{discretization}
and \code{nslices}. See \code{\link{SF.SIR}} for detail}
\item{For \code{DR}:}{arguments \code{etaopg} and \code{nslices}.
See \code{\link{SF.DR}} for detail}
}}
}
\value{
Out-of-sample forecast for \code{newX}; or in-sample forecast for the last
observed data point if \code{newX} is \code{NULL}
}
\description{
Select a method from PC, SIR and DR to do point prediction
}
\examples{
utils::data(dataExample,package = "sufficientForecasting")
SF(dataExample$y,dataExample$X,method = "SIR.LLM",
hyperparameter = list(nslices = 5,discretization = TRUE))
SF(dataExample$y,dataExample$X,dataExample$newX,method = "DR")
SF(dataExample$y,dataExample$X,dataExample$newX,method = "PC")
}
\references{
Fan, J., Xue, L. and Yao, J. (2017), Sufficient forecasting using factor models,
\emph{Journal of econometrics} 201(2), 292–306

Luo, W., Xue, L., Yao, J. and Yu, X. (2022), Inverse moment methods for sufficient
forecasting using high-dimensional predictors, \emph{Biometrika} 109(2), 473–487.

Yu, X., Yao, J. and Xue, L. (2022), Nonparametric estimation and conformal inference
of the sufficient forecasting with a diverging number of factors,
\emph{Journal of Business & Economic Statistics} 40(1), 342–354.
}
