% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subformula.R
\name{subformula}
\alias{subformula}
\title{Calculate Subformulas}
\usage{
subformula(formula, protected = NULL, data = NULL)
}
\arguments{
\item{formula}{an object of class "\code{\link[stats:formula]{formula}}" (or one
that can be coerced to that class via \code{\link[stats:formula]{formula}}).}

\item{protected}{a vector or formula specifying which covariates are
\emph{protected}. Protected formulas appear in all subformulas.}

\item{data}{an optional data frame (or object coercible by
\code{\link[base:as.data.frame]{as.data.frame}} to a data frame). Used to fill
out formulas as \code{y ~ .}.}
}
\value{
\code{subformula} returns a list of \code{formula} objects.
}
\description{
A formula \code{sub} is a subformula of \code{formula} if \emph{(i)} all the terms
on the right hand side of \code{sub} are terms of \code{formula} and \emph{(ii)}
their left hand sides are identical. \code{subformula} finds every
subformula of \code{formula} that contains each term in \code{protected}.
}
\details{
Protected terms will appear in every subformula. If the supplied formula
includes the term \code{0} or \code{-1}, none of the subformulas will
include the intercept. Otherwise, the intercept will be interpreted as
being protected. If \code{formula} is is coerced to a \code{formula}
object, its associated \link[base:environment]{environment} will be
\code{NULL}. All subformulas will inherit their \code{.Environment}
attribute from \code{formula}.
}
\examples{
subformula(z ~ x + y)
subformula(y ~ x + y + y^2, protected = ~ x)
subformula(y ~ x + y + t + I(t^2), protected = c("x","I(t^2)"))
}
