% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_help_files.R
\name{sf_collapse}
\alias{sf_collapse}
\title{sf_collapse}
\usage{
sf_collapse(x, collapse)
}
\arguments{
\item{x}{A character vector}

\item{collapse}{A single string}
}
\value{
A single string with all values in `x` pasted together, separated by `collapse`.
}
\description{
Pastes a series of strings together separated by the `collapse` parameter
}
\details{
This works the same way as `paste0(x, collapse=collapse)`
}
\examples{
if(getRversion() >= "3.5.0") {
x <- c("hello", "\\\\xe4\\\\xb8\\\\x96\\\\xe7\\\\x95\\\\x8c")
Encoding(x) <- "UTF-8"
sf_collapse(x, " ") # "hello world" in Japanese
sf_collapse(letters, "") # returns the alphabet
}
}
\seealso{
paste0, paste
}
