% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_asym.R
\name{reg_asym}
\alias{reg_asym}
\title{Asymptotic Regression}
\usage{
reg_asym(
  formula,
  data,
  method = "BFGS",
  init_guess = rep(1, ncol(data) * 2 - 1),
  ...
)
}
\arguments{
\item{formula}{A formula object to describe the relationship.}

\item{data}{The response and predictor variables.}

\item{method}{The method that is passed to the optim function. By default, it
is the BFGS method which uses a gradient.}

\item{init_guess}{The initial parameter guesses for the optim function. By
default, it is all ones.}

\item{...}{Additional arguments passed to the optim function.}
}
\value{
A "reg_asym" object is returned which contains the results from the
 optim function that was returned.
}
\description{
A simple example of asymptotic regression that is in the form of
 \eqn{y = -e^{-x}} and is the sum of multiple of these exponential
 functions with a common intercept term.
}
\examples{
 asym_data <- data_gen_asym(10)
 reg_asym(Y ~ ., asym_data)
}
