% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholds.R
\name{thresholds}
\alias{thresholds}
\title{Find thresholds for each season}
\usage{
thresholds(
  dates,
  values,
  season_start = 10,
  n_seasons = 4,
  half_win = 2,
  threshold = 0.8
)
}
\arguments{
\item{dates}{A vector of dates of 'Date' class.}

\item{values}{Numeric values. The values must be in correspondence with \code{dates}, meaning the
\emph{i}th element in \code{values} must correspond to the \emph{i}th date in \code{dates}.}

\item{season_start}{The starting month of the first season, specified as an integer from 1 to
12. Default is 10 (October).}

\item{n_seasons}{The number of seasons in a year. Must be a factor of 12. Default is 4.}

\item{half_win}{The half width of the window of years to group \code{thresh_ref} by. See 'Details'.}

\item{threshold}{The quantile of \code{thresh_ref} above which \code{values} is sampled \code{n_et_samples}
times per year.}
}
\value{
A data frame with three columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
season \tab integer \tab Season of the threshold \cr
threshold \tab numeric \tab Seasonal threshold \cr
center_year \tab integer \tab Middle year of the window \cr
}
}
\description{
Calculate the threshold for each unique season in a window of years. Values exceeding these
thresholds would be considered "high" based on the specified quantile. Intended to be used on a
(near) daily water quality record.
}
\details{
Thresholds are calculated based on groupings of seasonally adjusted years. If \code{half_win} is \code{2},
the default, then a total of 5 years is used to calculate the threshold. Years are adjusted
such that the year starts on the first of the month of the first season, as determined by
\code{season_start}, and end one year later, and is designated by the calendar year in which it ends.
For example, when \code{half_win} is 2, the threshold for season 1 of 2021 is the quantile defined by
\code{threshold} of all season 1 values in 2019, 2020, 2021, 2022, and 2023.
}
\examples{
date_vec <- seq.Date(
  from = as.Date("2020-05-03"), 
  to = as.Date("2023-10-17"), 
  by = "day"
)
set.seed(123)
q_vec <- stats::runif(length(date_vec), min = -50, max = 150)
df <- data.frame("date" = date_vec, "q" = q_vec)

results <- thresholds(
  dates = date_vec, 
  values = q_vec
)
print(head(results))

# Define seasons differently
results <- thresholds(
  dates = date_vec, 
  values = q_vec, 
  season_start = 1, 
  n_seasons = 3, 
  half_win = 2, 
  threshold = 0.9
)
print(head(results))
}
