% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_sign.R
\name{eval_sign}
\alias{eval_sign}
\title{Evaluate the sign of data}
\usage{
eval_sign(values)
}
\arguments{
\item{values}{A numeric vector to be evaluated.}
}
\value{
A data frame with one row and seven columns:
\tabular{lll}{
\strong{Name} \tab \strong{Type} \tab \strong{Description} \cr
n_pos \tab integer \tab number of non-negative values in the data \cr
pos_pct \tab numeric \tab percentage of non-negative values in the data \cr
n_neg \tab integer \tab number of negative values in the data \cr
neg_pct \tab numeric \tab percentage of negative values in the data \cr
n_na \tab integer \tab number of NA values in the data \cr
na_pct \tab numeric \tab percentage of NA values in the data \cr
tot_pct \tab numeric \tab sum of \code{pos_pct}, \code{neg_pct}, and \code{na_pct} \cr
}
}
\description{
Evaluate a numeric vector for the proportions of positive (> 0), negative (<= 0), and NA values.
Intended to be used on a water quality record.
}
\examples{
data <- c(-1, -2, 0, 1, 2, 3, -3, -4, 4)
eval_sign(data)

data_all_positive <- c(1, 2, 3, 4, 5)
eval_sign(data_all_positive)

data_all_negative <- c(-1, -2, -3, -4, -5)
eval_sign(data_all_negative)

data_mixed <- c(-1, 0, 1, 2, -2, -3, NA)
eval_sign(data_mixed)
}
