% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walker.R
\name{walker}
\alias{walker}
\title{A landscape walker}
\usage{
walker(n = 5, s_threshold = 250, step_length = 20,
poly = NULL, restriction_feat=NULL, field = NA, coords=c(0,0),
pt_itx = TRUE, show.plot = FALSE)
}
\arguments{
\item{n}{number of events
to be generated by a walker within a
temporal bin.}

\item{s_threshold}{defines the spatial
perception range of a walker at a given
location. Default: \code{250} (in the same
linear unit
as the \code{poly} - polygon shapefile).}

\item{step_length}{the maximum step taken
by a walker from one point to the next.}

\item{poly}{(An sf or S4 object)
a polygon shapefile defining the
extent of the landscape}

\item{restriction_feat}{(An S4 object) optional
shapefile containing features
in which walkers cannot walk through.
Default: \code{NULL}.}

\item{field}{a number in the range of \code{[0-1]}
(i.e. restriction values) assigned
to all features; or
the name of a numeric field to extract such
restriction values for different classes of
feature.
Restriction value \code{0} and \code{1} indicate the
lowest and the highest obstructions, respectively.
Default: \code{NULL}.}

\item{coords}{a vector of the form c(x, y) giving the
initial coordinates of a walker (i.e., coordinates
of origins).
Default value is \code{c(0,0)} for an
arbitrary square space.}

\item{pt_itx}{To check whether any of the
specified initial origin coordinates
falls outside the boundary.
Default: \code{TRUE}.}

\item{show.plot}{(TRUE or False) To show the time series
plot. Default is \code{FALSE}.}
}
\value{
Returns a trace of walker's path, and the
resulting events.
}
\description{
A dynamic object capable of moving
and avoiding obstacles on a landscape.
}
\details{
A walker is propelled by an in-built stochastic
transition matrix
and a specified set of spatial and temporal
parameters. The transition
matrix defines two states, namely; the \code{exploratory}
and a \code{performative} states. A walker is capable
of avoiding obstructions (i.e., \code{restriction_feat})
if included. The resulting number of events may be
slightly different from the value \code{n} because of the
stochastic process involved.
}
\examples{
#load boundary of Camden
load(file = system.file("extdata", "camden.rda",
package="stppSim"))
boundary = camden$boundary # get boundary
walkerpath <- walker(n = 5, s_threshold = 250, step_length = 20,
poly = boundary, restriction_feat=NULL, field = NULL,
coords = c(0,0), pt_itx = TRUE, show.plot = FALSE)
#plot(walkerpath)
}
\references{
Quaglietta L, Porto M (2019). SiMRiv: Individual-Based,
Spatially-Explicit Simulation and Analysis of Multi-State
Movements in River Networks and Heterogeneous Landscapes_.
R package version 1.0.4, <URL:
https://CRAN.R-project.org/package=SiMRiv>.
}
