% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_topics.R
\name{get_topics}
\alias{get_topics}
\title{Get list of topics and sub-topics for the Norwegian parliament}
\usage{
get_topics(keep_sub_topics = TRUE)
}
\arguments{
\item{keep_sub_topics}{Logical. Whether to keep sub-topics (default) for all main topics or not.}
}
\value{
A list with two elements:
\enumerate{
\item \strong{$topics} (All topics)\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{is_main_topic} \tab Logical indicator for whether the topic is a main topic \cr
   \strong{main_topic_id} \tab Id of main topic \cr
   \strong{id} \tab Id of topic \cr
   \strong{name} \tab Name of topic \cr
}

\item \strong{$main_topics} (exclusively main topics, if keep_sub_topics = TRUE)\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{is_main_topic} \tab Logical indicator for whether the topic is a main topic \cr
   \strong{main_topic_id} \tab Id of main topic \cr
   \strong{id} \tab Id of topic \cr
   \strong{name} \tab Name of topic \cr
}

}
}
\description{
A function for retrieving topic keys used to label various data from the Norwegian parliament.
}
\examples{
\dontrun{
# Request the data
tops <- get_topics()

# Look at the first main topic
tops$main_topics[1, ]

# Extract all sub-topics for the first main topic
tops$topics[which(tops$topics$main_topic_id == 5), ]
}

}
