% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.rule.tite.R
\name{lines.rule.tite}
\alias{lines.rule.tite}
\title{Add Stopping Rule Curve to Current Plot (TITE Method)}
\usage{
\method{lines}{rule.tite}(x, ...)
}
\arguments{
\item{x}{A \code{rule.tite} object calculated by \code{calc.rule.tite()} function}

\item{...}{Other options to be passed to generic \code{lines} function}
}
\value{
No return value; function solely modifies current plot
}
\description{
Add a TITE stopping rule graphically as a curve on current plot
}
\examples{
\dontrun{# Binomial Pocock test in 50 patient cohort at 10\% level, expected toxicity probability of 20\%
poc_rule = calc.rule.tite(n=50,p0=0.20,alpha=0.10,type="Pocock")

# Bayesian beta-extended binomial method in 50 patient cohort at 10\% level,
# expected toxicity probability of 20\%
bb_rule = calc.rule.tite(n=50,p0=0.20,alpha=0.10,type="BB",param=c(2,8))

# Plot stopping boundaries for stopping rules
plot(poc_rule,col="blue")
lines(bb_rule,col="red")
}
}
