% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals}
\alias{residuals}
\title{Calculate one-step-ahead (OSA) residuals for stochastic volatility model.}
\usage{
residuals(object, conditional = 1:(object$nobs - 100), ...)
}
\arguments{
\item{object}{A \code{stochvolTMB} object.}

\item{conditional}{Index vector of observations that are fixed during OSA. By default the residuals of the last 100
observations are calculated. If set to \code{NULL} it will calculate one-step-ahead residuals for all observations.}

\item{...}{Currently not used.}
}
\value{
Vector of one-step-ahead residuals. If the model is correctly specified, these should be standard normal.
}
\description{
This function is very time consuming and by default computes the one-step-ahead residual for the last 100 observations. 
See the function \link[TMB]{oneStepPredict} and the paper in the references for more details.
}
\references{
\url{https://www.researchgate.net/publication/316581864_Validation_of_ecological_state_space_models_using_the_Laplace_approximation}
}
