% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plot_pop_spatial}
\alias{plot_pop_spatial}
\title{Plot population spatial information}
\usage{
plot_pop_spatial(x, stage = 0, replicate = 1, timesteps = NULL, ...)
}
\arguments{
\item{x}{a simulation_results object}

\item{stage}{life-stage to plot - defaults to totals of all life stages. 
Set to zero for totals (i.e. sum of all life-stages).}

\item{replicate}{replicate to plot - note, only one replicate can be plotted
at a time. The default is to plot the first replicate}

\item{timesteps}{timesteps to plot}

\item{...}{further arguments passed to/from other methods}
}
\description{
Plot spatial grids to illustrate population changes through time.
}
\examples{

\dontrun{
ls <- landscape(population = egk_pop, suitability = egk_hab, carrying_capacity = egk_k)

pd <- population_dynamics(change = growth(egk_mat),
                          dispersal = kernel_dispersal(max_distance = 2000,
                                        dispersal_kernel = exponential_dispersal_kernel(
                                          distance_decay = 1000)),
                          density_dependence = ceiling_density())

sim <- simulation(landscape = ls,
                  population_dynamics = pd,
                  habitat_dynamics = NULL,
                  timesteps = 20)

# Plot the population trajectories by life-stage
plot_pop_spatial(sim)
}
}
