% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{Organization}
\alias{Organization}
\title{An organization such as a school, NGO, corporation, club, etc.}
\usage{
Organization(
  address,
  alternateNames,
  brands,
  contactPoints,
  departments,
  description,
  funders,
  id,
  identifiers,
  images,
  legalName,
  logo,
  members,
  meta,
  name,
  parentOrganization,
  url
)
}
\arguments{
\item{address}{Postal address for the organization.}

\item{alternateNames}{Alternate names (aliases) for the item.}

\item{brands}{Brands that the organization is connected with.}

\item{contactPoints}{Correspondence/Contact points for the organization.}

\item{departments}{Departments within the organization. For example, Department of Computer Science, Research & Development etc.}

\item{description}{A description of the item.}

\item{funders}{Organization(s) or person(s) funding the organization.}

\item{id}{The identifier for this item.}

\item{identifiers}{Any kind of identifier for any kind of Thing.}

\item{images}{Images of the item.}

\item{legalName}{Legal name for the Organization. Should only include letters and spaces.}

\item{logo}{The logo of the organization.}

\item{members}{Person(s) or organization(s) who are members of this organization.}

\item{meta}{Metadata associated with this item.}

\item{name}{The name of the item.}

\item{parentOrganization}{Entity that the Organization is a part of. For example, parentOrganization to a department is a university.}

\item{url}{The URL of the item.}
}
\value{
A \code{list} of class \code{Organization}
}
\description{
An organization such as a school, NGO, corporation, club, etc.
}
\seealso{
\code{\link{Thing}}
}
