# This file was automatically generated by `r.ts`.
# Do not modify it by hand. Instead, modify the source `.schema.yaml` files
# in the `schema` directory and run `npm run build:r` to regenerate it.

#' @include typing.R
NULL

#' The most simple compound (ie. non-atomic like `number`, `string` etc) type.
#'
#' @name Entity
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `Entity`
#' @export
Entity <- function(
  id,
  meta
){
  self <- list()
  self$type <- as_scalar("Entity")
  self[["id"]] <- check_property("Entity", "id", FALSE, missing(id), "character", id)
  self[["meta"]] <- check_property("Entity", "meta", FALSE, missing(meta), "list", meta)
  class(self) <- c(class(self), "Entity")
  self
}


#' A validator specifying constraints on an array node.
#'
#' @name ArrayValidator
#' @param contains An array node is valid if at least one of its items is valid against the `contains` schema.
#' @param id The identifier for this item.
#' @param itemsValidator Another validator node specifying the constraints on all items in the array.
#' @param maxItems An array node is valid if its size is less than, or equal to, this value.
#' @param meta Metadata associated with this item.
#' @param minItems An array node is valid if its size is greater than, or equal to, this value.
#' @param uniqueItems A flag to indicate that each value in the array should be unique.
#' @return A `list` of class `ArrayValidator`
#' @seealso \code{\link{Entity}}
#' @export
ArrayValidator <- function(
  contains,
  id,
  itemsValidator,
  maxItems,
  meta,
  minItems,
  uniqueItems
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("ArrayValidator")
  self[["contains"]] <- check_property("ArrayValidator", "contains", FALSE, missing(contains), ValidatorTypes, contains)
  self[["itemsValidator"]] <- check_property("ArrayValidator", "itemsValidator", FALSE, missing(itemsValidator), ValidatorTypes, itemsValidator)
  self[["maxItems"]] <- check_property("ArrayValidator", "maxItems", FALSE, missing(maxItems), "numeric", maxItems)
  self[["minItems"]] <- check_property("ArrayValidator", "minItems", FALSE, missing(minItems), "numeric", minItems)
  self[["uniqueItems"]] <- check_property("ArrayValidator", "uniqueItems", FALSE, missing(uniqueItems), "logical", uniqueItems)
  class(self) <- c(class(self), "ArrayValidator")
  self
}


#' A schema specifying that a node must be a boolean value.
#'
#' @name BooleanValidator
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `BooleanValidator`
#' @seealso \code{\link{Entity}}
#' @export
BooleanValidator <- function(
  id,
  meta
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("BooleanValidator")

  class(self) <- c(class(self), "BooleanValidator")
  self
}


#' A reference to a CreativeWork that is cited in another CreativeWork.
#'
#' @name Cite
#' @param target The target of the citation (URL or reference ID). \bold{Required}.
#' @param citationMode How the cite is rendered in the surrounding text.
#' @param content Optional structured content/text of this citation.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @param pageEnd The page on which the work ends; for example "138" or "xvi".
#' @param pageStart The page on which the work starts; for example "135" or "xiii".
#' @param pagination Any description of pages that is not separated into pageStart and pageEnd; for example, "1-6, 9, 55".
#' @param prefix A prefix to show before the citation.
#' @param suffix A suffix to show after the citation.
#' @return A `list` of class `Cite`
#' @seealso \code{\link{Entity}}
#' @export
Cite <- function(
  target,
  citationMode,
  content,
  id,
  meta,
  pageEnd,
  pageStart,
  pagination,
  prefix,
  suffix
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Cite")
  self[["target"]] <- check_property("Cite", "target", TRUE, missing(target), "character", target)
  self[["citationMode"]] <- check_property("Cite", "citationMode", FALSE, missing(citationMode), Enum("normal", "suppressAuthor"), citationMode)
  self[["content"]] <- check_property("Cite", "content", FALSE, missing(content), Array(InlineContent), content)
  self[["pageEnd"]] <- check_property("Cite", "pageEnd", FALSE, missing(pageEnd), Union("numeric", "character"), pageEnd)
  self[["pageStart"]] <- check_property("Cite", "pageStart", FALSE, missing(pageStart), Union("numeric", "character"), pageStart)
  self[["pagination"]] <- check_property("Cite", "pagination", FALSE, missing(pagination), "character", pagination)
  self[["prefix"]] <- check_property("Cite", "prefix", FALSE, missing(prefix), "character", prefix)
  self[["suffix"]] <- check_property("Cite", "suffix", FALSE, missing(suffix), "character", suffix)
  class(self) <- c(class(self), "Cite")
  self
}


#' A group of `Cite` nodes
#'
#' @name CiteGroup
#' @param items One or more `Cite`s to be referenced in the same surrounding text. \bold{Required}.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `CiteGroup`
#' @seealso \code{\link{Entity}}
#' @export
CiteGroup <- function(
  items,
  id,
  meta
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("CiteGroup")
  self[["items"]] <- check_property("CiteGroup", "items", TRUE, missing(items), Array(Cite), items)
  class(self) <- c(class(self), "CiteGroup")
  self
}


#' Base type for code nodes e.g. `CodeBlock`, `CodeExpression`.
#'
#' @name Code
#' @param text The text of the code. \bold{Required}.
#' @param format Media type, typically expressed using a MIME format, of the code.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @param programmingLanguage The programming language of the code.
#' @return A `list` of class `Code`
#' @seealso \code{\link{Entity}}
#' @export
Code <- function(
  text,
  format,
  id,
  meta,
  programmingLanguage
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Code")
  self[["text"]] <- check_property("Code", "text", TRUE, missing(text), "character", text)
  self[["format"]] <- check_property("Code", "format", FALSE, missing(format), "character", format)
  self[["programmingLanguage"]] <- check_property("Code", "programmingLanguage", FALSE, missing(programmingLanguage), "character", programmingLanguage)
  class(self) <- c(class(self), "Code")
  self
}


#' A code block.
#'
#' @name CodeBlock
#' @param text The text of the code. \bold{Required}.
#' @param exportFrom A compilation directive giving the name of the variable to export into the content of the code block.
#' @param format Media type, typically expressed using a MIME format, of the code.
#' @param id The identifier for this item.
#' @param importTo A compilation directive giving the name of the variable to import the content of the code block as.
#' @param meta Metadata associated with this item.
#' @param programmingLanguage The programming language of the code.
#' @return A `list` of class `CodeBlock`
#' @seealso \code{\link{Code}}
#' @export
CodeBlock <- function(
  text,
  exportFrom,
  format,
  id,
  importTo,
  meta,
  programmingLanguage
){
  self <- Code(
    text = text,
    format = format,
    id = id,
    meta = meta,
    programmingLanguage = programmingLanguage
  )
  self$type <- as_scalar("CodeBlock")
  self[["exportFrom"]] <- check_property("CodeBlock", "exportFrom", FALSE, missing(exportFrom), "character", exportFrom)
  self[["importTo"]] <- check_property("CodeBlock", "importTo", FALSE, missing(importTo), "character", importTo)
  class(self) <- c(class(self), "CodeBlock")
  self
}


#' A executable chunk of code.
#'
#' @name CodeChunk
#' @param text The text of the code. \bold{Required}.
#' @param alters Names of variables that the code chunk alters.
#' @param assigns Variables that the code chunk assigns to.
#' @param caption A caption for the CodeChunk.
#' @param declares Variables that the code chunk declares.
#' @param duration Duration in seconds of the last execution of the chunk.
#' @param errors Errors when compiling or executing the chunk.
#' @param exportFrom A compilation directive giving the name of the variable to export into the content of the code block.
#' @param format Media type, typically expressed using a MIME format, of the code.
#' @param id The identifier for this item.
#' @param importTo A compilation directive giving the name of the variable to import the content of the code block as.
#' @param imports Software packages that the code chunk imports
#' @param label A short label for the CodeChunk.
#' @param meta Metadata associated with this item.
#' @param outputs Outputs from executing the chunk.
#' @param programmingLanguage The programming language of the code.
#' @param reads Filesystem paths that this code chunk reads from.
#' @param uses Names of variables that the code chunk uses (but does not alter).
#' @return A `list` of class `CodeChunk`
#' @seealso \code{\link{CodeBlock}}
#' @export
#' @examples
#' CodeChunk(
#'   programmingLanguage = "r",
#'   text = "plot(1)",
#'   label = "Figure 1",
#'   id = "fig1",
#'   caption = list(
#'     Heading(
#'       content = list("Figure title"),
#'       depth = 2
#'     ),
#'     Paragraph(
#'       content = list(
#'         "A paragraph with some",
#'         Strong(content = list("strong emphasis")),
#'         "in it."
#'       )
#'     )
#'   )
#' )
CodeChunk <- function(
  text,
  alters,
  assigns,
  caption,
  declares,
  duration,
  errors,
  exportFrom,
  format,
  id,
  importTo,
  imports,
  label,
  meta,
  outputs,
  programmingLanguage,
  reads,
  uses
){
  self <- CodeBlock(
    text = text,
    exportFrom = exportFrom,
    format = format,
    id = id,
    importTo = importTo,
    meta = meta,
    programmingLanguage = programmingLanguage
  )
  self$type <- as_scalar("CodeChunk")
  self[["alters"]] <- check_property("CodeChunk", "alters", FALSE, missing(alters), Array("character"), alters)
  self[["assigns"]] <- check_property("CodeChunk", "assigns", FALSE, missing(assigns), Array(Union("character", Variable)), assigns)
  self[["caption"]] <- check_property("CodeChunk", "caption", FALSE, missing(caption), Union("character", Array(Node)), caption)
  self[["declares"]] <- check_property("CodeChunk", "declares", FALSE, missing(declares), Array(Union("character", Variable, Function)), declares)
  self[["duration"]] <- check_property("CodeChunk", "duration", FALSE, missing(duration), "numeric", duration)
  self[["errors"]] <- check_property("CodeChunk", "errors", FALSE, missing(errors), Array(CodeError), errors)
  self[["imports"]] <- check_property("CodeChunk", "imports", FALSE, missing(imports), Array(Union("character", SoftwareSourceCode, SoftwareApplication)), imports)
  self[["label"]] <- check_property("CodeChunk", "label", FALSE, missing(label), "character", label)
  self[["outputs"]] <- check_property("CodeChunk", "outputs", FALSE, missing(outputs), Array(Node), outputs)
  self[["reads"]] <- check_property("CodeChunk", "reads", FALSE, missing(reads), Array("character"), reads)
  self[["uses"]] <- check_property("CodeChunk", "uses", FALSE, missing(uses), Array(Union("character", Variable)), uses)
  class(self) <- c(class(self), "CodeChunk")
  self
}


#' Inline code.
#'
#' @name CodeFragment
#' @param text The text of the code. \bold{Required}.
#' @param format Media type, typically expressed using a MIME format, of the code.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @param programmingLanguage The programming language of the code.
#' @return A `list` of class `CodeFragment`
#' @seealso \code{\link{Code}}
#' @export
CodeFragment <- function(
  text,
  format,
  id,
  meta,
  programmingLanguage
){
  self <- Code(
    text = text,
    format = format,
    id = id,
    meta = meta,
    programmingLanguage = programmingLanguage
  )
  self$type <- as_scalar("CodeFragment")

  class(self) <- c(class(self), "CodeFragment")
  self
}


#' An expression defined in programming language source code.
#'
#' @name CodeExpression
#' @param text The text of the code. \bold{Required}.
#' @param errors Errors when compiling or executing the chunk.
#' @param format Media type, typically expressed using a MIME format, of the code.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @param output The value of the expression when it was last evaluated.
#' @param programmingLanguage The programming language of the code.
#' @return A `list` of class `CodeExpression`
#' @seealso \code{\link{CodeFragment}}
#' @export
CodeExpression <- function(
  text,
  errors,
  format,
  id,
  meta,
  output,
  programmingLanguage
){
  self <- CodeFragment(
    text = text,
    format = format,
    id = id,
    meta = meta,
    programmingLanguage = programmingLanguage
  )
  self$type <- as_scalar("CodeExpression")
  self[["errors"]] <- check_property("CodeExpression", "errors", FALSE, missing(errors), Array(CodeError), errors)
  self[["output"]] <- check_property("CodeExpression", "output", FALSE, missing(output), Node, output)
  class(self) <- c(class(self), "CodeExpression")
  self
}


#' An error that occurred when parsing, compiling or executing a Code node.
#'
#' @name CodeError
#' @param errorMessage The error message or brief description of the error. \bold{Required}.
#' @param errorType The type of error e.g. "SyntaxError", "ZeroDivisionError".
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @param stackTrace Stack trace leading up to the error.
#' @return A `list` of class `CodeError`
#' @seealso \code{\link{Entity}}
#' @export
CodeError <- function(
  errorMessage,
  errorType,
  id,
  meta,
  stackTrace
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("CodeError")
  self[["errorMessage"]] <- check_property("CodeError", "errorMessage", TRUE, missing(errorMessage), "character", errorMessage)
  self[["errorType"]] <- check_property("CodeError", "errorType", FALSE, missing(errorType), "character", errorType)
  self[["stackTrace"]] <- check_property("CodeError", "stackTrace", FALSE, missing(stackTrace), "character", stackTrace)
  class(self) <- c(class(self), "CodeError")
  self
}


#' A validator specifying a constant value that a node must have.
#'
#' @name ConstantValidator
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @param value The value that the node must have.
#' @return A `list` of class `ConstantValidator`
#' @seealso \code{\link{Entity}}
#' @export
ConstantValidator <- function(
  id,
  meta,
  value
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("ConstantValidator")
  self[["value"]] <- check_property("ConstantValidator", "value", FALSE, missing(value), Node, value)
  class(self) <- c(class(self), "ConstantValidator")
  self
}


#' A date encoded as a ISO 8601 string.
#'
#' @name Date
#' @param value The date as an ISO 8601 string. \bold{Required}.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `Date`
#' @seealso \code{\link{Entity}}
#' @export
Date <- function(
  value,
  id,
  meta
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Date")
  self[["value"]] <- check_property("Date", "value", TRUE, missing(value), "character", value)
  class(self) <- c(class(self), "Date")
  self
}


#' A base class for nodes that mark some other inline content in some way (e.g. as being emphasised, or quoted).
#'
#' @name Mark
#' @param content The content that is marked. \bold{Required}.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `Mark`
#' @seealso \code{\link{Entity}}
#' @export
Mark <- function(
  content,
  id,
  meta
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Mark")
  self[["content"]] <- check_property("Mark", "content", TRUE, missing(content), Array(InlineContent), content)
  class(self) <- c(class(self), "Mark")
  self
}


#' Content that is marked for deletion
#'
#' @name Delete
#' @param content The content that is marked. \bold{Required}.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `Delete`
#' @seealso \code{\link{Mark}}
#' @export
Delete <- function(
  content,
  id,
  meta
){
  self <- Mark(
    content = content,
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Delete")

  class(self) <- c(class(self), "Delete")
  self
}


#' Emphasised content.
#'
#' @name Emphasis
#' @param content The content that is marked. \bold{Required}.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `Emphasis`
#' @seealso \code{\link{Mark}}
#' @export
Emphasis <- function(
  content,
  id,
  meta
){
  self <- Mark(
    content = content,
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Emphasis")

  class(self) <- c(class(self), "Emphasis")
  self
}


#' The most generic type of item.
#'
#' @name Thing
#' @param alternateNames Alternate names (aliases) for the item.
#' @param description A description of the item.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param url The URL of the item.
#' @return A `list` of class `Thing`
#' @seealso \code{\link{Entity}}
#' @export
Thing <- function(
  alternateNames,
  description,
  id,
  identifiers,
  images,
  meta,
  name,
  url
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Thing")
  self[["alternateNames"]] <- check_property("Thing", "alternateNames", FALSE, missing(alternateNames), Array("character"), alternateNames)
  self[["description"]] <- check_property("Thing", "description", FALSE, missing(description), Union(Array(BlockContent), Array(InlineContent), "character"), description)
  self[["identifiers"]] <- check_property("Thing", "identifiers", FALSE, missing(identifiers), Array(Union(PropertyValue, "character")), identifiers)
  self[["images"]] <- check_property("Thing", "images", FALSE, missing(images), Array(Union(ImageObject, "character")), images)
  self[["name"]] <- check_property("Thing", "name", FALSE, missing(name), "character", name)
  self[["url"]] <- check_property("Thing", "url", FALSE, missing(url), "character", url)
  class(self) <- c(class(self), "Thing")
  self
}


#' A brand used by an organization or person for labeling a product, product group, or similar.
#'
#' @name Brand
#' @param name The name of the item. \bold{Required}.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param description A description of the item.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param logo A logo associated with the brand.
#' @param meta Metadata associated with this item.
#' @param reviews Reviews of the brand.
#' @param url The URL of the item.
#' @return A `list` of class `Brand`
#' @seealso \code{\link{Thing}}
#' @export
Brand <- function(
  name,
  alternateNames,
  description,
  id,
  identifiers,
  images,
  logo,
  meta,
  reviews,
  url
){
  self <- Thing(
    name = name,
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    url = url
  )
  self$type <- as_scalar("Brand")
  self[["name"]] <- check_property("Brand", "name", TRUE, missing(name), "character", name)
  self[["logo"]] <- check_property("Brand", "logo", FALSE, missing(logo), Union("character", ImageObject), logo)
  self[["reviews"]] <- check_property("Brand", "reviews", FALSE, missing(reviews), Array("character"), reviews)
  class(self) <- c(class(self), "Brand")
  self
}


#' A contact point, for example, a R&D department.
#'
#' @name ContactPoint
#' @param alternateNames Alternate names (aliases) for the item.
#' @param availableLanguages Languages (human not programming) in which it is possible to communicate with the organization/department etc.
#' @param description A description of the item.
#' @param emails Email address for correspondence.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param telephoneNumbers Telephone numbers for the contact point.
#' @param url The URL of the item.
#' @return A `list` of class `ContactPoint`
#' @seealso \code{\link{Thing}}
#' @export
ContactPoint <- function(
  alternateNames,
  availableLanguages,
  description,
  emails,
  id,
  identifiers,
  images,
  meta,
  name,
  telephoneNumbers,
  url
){
  self <- Thing(
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    name = name,
    url = url
  )
  self$type <- as_scalar("ContactPoint")
  self[["availableLanguages"]] <- check_property("ContactPoint", "availableLanguages", FALSE, missing(availableLanguages), Array("character"), availableLanguages)
  self[["emails"]] <- check_property("ContactPoint", "emails", FALSE, missing(emails), Array("character"), emails)
  self[["telephoneNumbers"]] <- check_property("ContactPoint", "telephoneNumbers", FALSE, missing(telephoneNumbers), Array("character"), telephoneNumbers)
  class(self) <- c(class(self), "ContactPoint")
  self
}


#' A creative work, including books, movies, photographs, software programs, etc.
#'
#' @name CreativeWork
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `CreativeWork`
#' @seealso \code{\link{Thing}}
#' @export
CreativeWork <- function(
  about,
  alternateNames,
  authors,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  parts,
  publisher,
  references,
  text,
  title,
  url,
  version
){
  self <- Thing(
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    name = name,
    url = url
  )
  self$type <- as_scalar("CreativeWork")
  self[["about"]] <- check_property("CreativeWork", "about", FALSE, missing(about), Array(Thing), about)
  self[["authors"]] <- check_property("CreativeWork", "authors", FALSE, missing(authors), Array(Union(Person, Organization)), authors)
  self[["comments"]] <- check_property("CreativeWork", "comments", FALSE, missing(comments), Array(Comment), comments)
  self[["content"]] <- check_property("CreativeWork", "content", FALSE, missing(content), Array(Node), content)
  self[["dateAccepted"]] <- check_property("CreativeWork", "dateAccepted", FALSE, missing(dateAccepted), Union(Date, "character"), dateAccepted)
  self[["dateCreated"]] <- check_property("CreativeWork", "dateCreated", FALSE, missing(dateCreated), Union(Date, "character"), dateCreated)
  self[["dateModified"]] <- check_property("CreativeWork", "dateModified", FALSE, missing(dateModified), Union(Date, "character"), dateModified)
  self[["datePublished"]] <- check_property("CreativeWork", "datePublished", FALSE, missing(datePublished), Union(Date, "character"), datePublished)
  self[["dateReceived"]] <- check_property("CreativeWork", "dateReceived", FALSE, missing(dateReceived), Union(Date, "character"), dateReceived)
  self[["editors"]] <- check_property("CreativeWork", "editors", FALSE, missing(editors), Array(Person), editors)
  self[["fundedBy"]] <- check_property("CreativeWork", "fundedBy", FALSE, missing(fundedBy), Array(Union(Grant, MonetaryGrant)), fundedBy)
  self[["funders"]] <- check_property("CreativeWork", "funders", FALSE, missing(funders), Array(Union(Person, Organization)), funders)
  self[["genre"]] <- check_property("CreativeWork", "genre", FALSE, missing(genre), Array("character"), genre)
  self[["isPartOf"]] <- check_property("CreativeWork", "isPartOf", FALSE, missing(isPartOf), CreativeWorkTypes, isPartOf)
  self[["keywords"]] <- check_property("CreativeWork", "keywords", FALSE, missing(keywords), Array("character"), keywords)
  self[["licenses"]] <- check_property("CreativeWork", "licenses", FALSE, missing(licenses), Array(Union(CreativeWorkTypes, "character")), licenses)
  self[["maintainers"]] <- check_property("CreativeWork", "maintainers", FALSE, missing(maintainers), Array(Union(Organization, Person)), maintainers)
  self[["parts"]] <- check_property("CreativeWork", "parts", FALSE, missing(parts), Array(CreativeWorkTypes), parts)
  self[["publisher"]] <- check_property("CreativeWork", "publisher", FALSE, missing(publisher), Union(Person, Organization), publisher)
  self[["references"]] <- check_property("CreativeWork", "references", FALSE, missing(references), Array(Union(CreativeWorkTypes, "character")), references)
  self[["text"]] <- check_property("CreativeWork", "text", FALSE, missing(text), "character", text)
  self[["title"]] <- check_property("CreativeWork", "title", FALSE, missing(title), Union(Array(InlineContent), "character"), title)
  self[["version"]] <- check_property("CreativeWork", "version", FALSE, missing(version), Union("character", "numeric"), version)
  class(self) <- c(class(self), "CreativeWork")
  self
}


#' An article, including news and scholarly articles.
#'
#' @name Article
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param pageEnd The page on which the article ends; for example "138" or "xvi".
#' @param pageStart The page on which the article starts; for example "135" or "xiii".
#' @param pagination Any description of pages that is not separated into pageStart and pageEnd; for example, "1-6, 9, 55".
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `Article`
#' @seealso \code{\link{CreativeWork}}
#' @export
Article <- function(
  about,
  alternateNames,
  authors,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  pageEnd,
  pageStart,
  pagination,
  parts,
  publisher,
  references,
  text,
  title,
  url,
  version
){
  self <- CreativeWork(
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    comments = comments,
    content = content,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("Article")
  self[["pageEnd"]] <- check_property("Article", "pageEnd", FALSE, missing(pageEnd), Union("numeric", "character"), pageEnd)
  self[["pageStart"]] <- check_property("Article", "pageStart", FALSE, missing(pageStart), Union("numeric", "character"), pageStart)
  self[["pagination"]] <- check_property("Article", "pagination", FALSE, missing(pagination), "character", pagination)
  class(self) <- c(class(self), "Article")
  self
}


#' A created collection of CreativeWorks or other artefacts.
#'
#' @name Collection
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.  \bold{Required}.
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `Collection`
#' @seealso \code{\link{CreativeWork}}
#' @export
Collection <- function(
  parts,
  about,
  alternateNames,
  authors,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  publisher,
  references,
  text,
  title,
  url,
  version
){
  self <- CreativeWork(
    parts = parts,
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    comments = comments,
    content = content,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("Collection")
  self[["parts"]] <- check_property("Collection", "parts", TRUE, missing(parts), Array(CreativeWorkTypes), parts)
  class(self) <- c(class(self), "Collection")
  self
}


#' A comment on an item, e.g on a Article, or SoftwareSourceCode.
#'
#' @name Comment
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param commentAspect The part or facet of the item that is being commented on.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parentItem The parent comment of this comment.
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `Comment`
#' @seealso \code{\link{CreativeWork}}
#' @export
Comment <- function(
  about,
  alternateNames,
  authors,
  commentAspect,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  parentItem,
  parts,
  publisher,
  references,
  text,
  title,
  url,
  version
){
  self <- CreativeWork(
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    comments = comments,
    content = content,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("Comment")
  self[["commentAspect"]] <- check_property("Comment", "commentAspect", FALSE, missing(commentAspect), "character", commentAspect)
  self[["parentItem"]] <- check_property("Comment", "parentItem", FALSE, missing(parentItem), Comment, parentItem)
  class(self) <- c(class(self), "Comment")
  self
}


#' A table of data.
#'
#' @name Datatable
#' @param columns The columns of data. \bold{Required}.
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `Datatable`
#' @seealso \code{\link{CreativeWork}}
#' @export
Datatable <- function(
  columns,
  about,
  alternateNames,
  authors,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  parts,
  publisher,
  references,
  text,
  title,
  url,
  version
){
  self <- CreativeWork(
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    comments = comments,
    content = content,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("Datatable")
  self[["columns"]] <- check_property("Datatable", "columns", TRUE, missing(columns), Array(DatatableColumn), columns)
  class(self) <- c(class(self), "Datatable")
  self
}


#' A media object, such as an image, video, or audio object embedded in a web page or a downloadable dataset.
#'
#' @name MediaObject
#' @param contentUrl URL for the actual bytes of the media object, for example the image file or video file.  \bold{Required}.
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param bitrate Bitrate in megabits per second (Mbit/s, Mb/s, Mbps).
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param contentSize File size in megabits (Mbit, Mb).
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param embedUrl URL that can be used to embed the media on a web page via a specific media player.
#' @param format Media type (MIME type) as per http://www.iana.org/assignments/media-types/media-types.xhtml.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `MediaObject`
#' @seealso \code{\link{CreativeWork}}
#' @export
MediaObject <- function(
  contentUrl,
  about,
  alternateNames,
  authors,
  bitrate,
  comments,
  content,
  contentSize,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  embedUrl,
  format,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  parts,
  publisher,
  references,
  text,
  title,
  url,
  version
){
  self <- CreativeWork(
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    comments = comments,
    content = content,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("MediaObject")
  self[["contentUrl"]] <- check_property("MediaObject", "contentUrl", TRUE, missing(contentUrl), "character", contentUrl)
  self[["bitrate"]] <- check_property("MediaObject", "bitrate", FALSE, missing(bitrate), "numeric", bitrate)
  self[["contentSize"]] <- check_property("MediaObject", "contentSize", FALSE, missing(contentSize), "numeric", contentSize)
  self[["embedUrl"]] <- check_property("MediaObject", "embedUrl", FALSE, missing(embedUrl), "character", embedUrl)
  self[["format"]] <- check_property("MediaObject", "format", FALSE, missing(format), "character", format)
  class(self) <- c(class(self), "MediaObject")
  self
}


#' An audio file
#'
#' @name AudioObject
#' @param contentUrl URL for the actual bytes of the media object, for example the image file or video file.  \bold{Required}.
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param bitrate Bitrate in megabits per second (Mbit/s, Mb/s, Mbps).
#' @param caption The caption for this audio recording.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param contentSize File size in megabits (Mbit, Mb).
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param embedUrl URL that can be used to embed the media on a web page via a specific media player.
#' @param format Media type (MIME type) as per http://www.iana.org/assignments/media-types/media-types.xhtml.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param transcript The transcript of this audio recording.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `AudioObject`
#' @seealso \code{\link{MediaObject}}
#' @export
AudioObject <- function(
  contentUrl,
  about,
  alternateNames,
  authors,
  bitrate,
  caption,
  comments,
  content,
  contentSize,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  embedUrl,
  format,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  parts,
  publisher,
  references,
  text,
  title,
  transcript,
  url,
  version
){
  self <- MediaObject(
    contentUrl = contentUrl,
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    bitrate = bitrate,
    comments = comments,
    content = content,
    contentSize = contentSize,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    embedUrl = embedUrl,
    format = format,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("AudioObject")
  self[["caption"]] <- check_property("AudioObject", "caption", FALSE, missing(caption), "character", caption)
  self[["transcript"]] <- check_property("AudioObject", "transcript", FALSE, missing(transcript), "character", transcript)
  class(self) <- c(class(self), "AudioObject")
  self
}


#' A column of data within a Datatable.
#'
#' @name DatatableColumn
#' @param name The name of the item. \bold{Required}.
#' @param values The data values of the column. \bold{Required}.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param description A description of the item.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param meta Metadata associated with this item.
#' @param url The URL of the item.
#' @param validator The validator to use to validate data in the column.
#' @return A `list` of class `DatatableColumn`
#' @seealso \code{\link{Thing}}
#' @export
DatatableColumn <- function(
  name,
  values,
  alternateNames,
  description,
  id,
  identifiers,
  images,
  meta,
  url,
  validator
){
  self <- Thing(
    name = name,
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    url = url
  )
  self$type <- as_scalar("DatatableColumn")
  self[["name"]] <- check_property("DatatableColumn", "name", TRUE, missing(name), "character", name)
  self[["values"]] <- check_property("DatatableColumn", "values", TRUE, missing(values), Array(Any()), values)
  self[["validator"]] <- check_property("DatatableColumn", "validator", FALSE, missing(validator), ArrayValidator, validator)
  class(self) <- c(class(self), "DatatableColumn")
  self
}


#' A word, name, acronym, phrase, etc. with a formal definition.
#'
#' @name DefinedTerm
#' @param name The name of the item. \bold{Required}.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param description A description of the item.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param meta Metadata associated with this item.
#' @param termCode A code that identifies this DefinedTerm within a DefinedTermSet
#' @param url The URL of the item.
#' @return A `list` of class `DefinedTerm`
#' @seealso \code{\link{Thing}}
#' @export
DefinedTerm <- function(
  name,
  alternateNames,
  description,
  id,
  identifiers,
  images,
  meta,
  termCode,
  url
){
  self <- Thing(
    name = name,
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    url = url
  )
  self$type <- as_scalar("DefinedTerm")
  self[["name"]] <- check_property("DefinedTerm", "name", TRUE, missing(name), "character", name)
  self[["termCode"]] <- check_property("DefinedTerm", "termCode", FALSE, missing(termCode), "character", termCode)
  class(self) <- c(class(self), "DefinedTerm")
  self
}


#' A schema specifying that a node must be one of several values.
#'
#' @name EnumValidator
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @param values A node is valid if it is equal to any of these values.
#' @return A `list` of class `EnumValidator`
#' @seealso \code{\link{Entity}}
#' @export
EnumValidator <- function(
  id,
  meta,
  values
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("EnumValidator")
  self[["values"]] <- check_property("EnumValidator", "values", FALSE, missing(values), Array(Node), values)
  class(self) <- c(class(self), "EnumValidator")
  self
}


#' Encapsulates one or more images, videos, tables, etc, and provides captions and labels for them.
#'
#' @name Figure
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param caption A caption for the figure.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param label A short label for the figure.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `Figure`
#' @seealso \code{\link{CreativeWork}}
#' @export
Figure <- function(
  about,
  alternateNames,
  authors,
  caption,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  label,
  licenses,
  maintainers,
  meta,
  name,
  parts,
  publisher,
  references,
  text,
  title,
  url,
  version
){
  self <- CreativeWork(
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    comments = comments,
    content = content,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("Figure")
  self[["caption"]] <- check_property("Figure", "caption", FALSE, missing(caption), Union("character", Array(Node)), caption)
  self[["label"]] <- check_property("Figure", "label", FALSE, missing(label), "character", label)
  class(self) <- c(class(self), "Figure")
  self
}


#' A function with a name, which might take Parameters and return a value of a certain type.
#'
#' @name Function
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @param name The name of the function.
#' @param parameters The parameters of the function.
#' @param returns The return type of the function.
#' @return A `list` of class `Function`
#' @seealso \code{\link{Entity}}
#' @export
Function <- function(
  id,
  meta,
  name,
  parameters,
  returns
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Function")
  self[["name"]] <- check_property("Function", "name", FALSE, missing(name), "character", name)
  self[["parameters"]] <- check_property("Function", "parameters", FALSE, missing(parameters), Array(Parameter), parameters)
  self[["returns"]] <- check_property("Function", "returns", FALSE, missing(returns), ValidatorTypes, returns)
  class(self) <- c(class(self), "Function")
  self
}


#' A grant, typically financial or otherwise quantifiable, of resources.
#'
#' @name Grant
#' @param alternateNames Alternate names (aliases) for the item.
#' @param description A description of the item.
#' @param fundedItems Indicates an item funded or sponsored through a Grant.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param sponsors A person or organization that supports a thing through a pledge, promise, or financial contribution.
#' @param url The URL of the item.
#' @return A `list` of class `Grant`
#' @seealso \code{\link{Thing}}
#' @export
Grant <- function(
  alternateNames,
  description,
  fundedItems,
  id,
  identifiers,
  images,
  meta,
  name,
  sponsors,
  url
){
  self <- Thing(
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    name = name,
    url = url
  )
  self$type <- as_scalar("Grant")
  self[["fundedItems"]] <- check_property("Grant", "fundedItems", FALSE, missing(fundedItems), Array(Thing), fundedItems)
  self[["sponsors"]] <- check_property("Grant", "sponsors", FALSE, missing(sponsors), Array(Union(Person, Organization)), sponsors)
  class(self) <- c(class(self), "Grant")
  self
}


#' Heading
#'
#' @name Heading
#' @param content Content of the heading. \bold{Required}.
#' @param depth The depth of the heading.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `Heading`
#' @seealso \code{\link{Entity}}
#' @export
Heading <- function(
  content,
  depth,
  id,
  meta
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Heading")
  self[["content"]] <- check_property("Heading", "content", TRUE, missing(content), Array(InlineContent), content)
  self[["depth"]] <- check_property("Heading", "depth", FALSE, missing(depth), "numeric", depth)
  class(self) <- c(class(self), "Heading")
  self
}


#' An image file.
#'
#' @name ImageObject
#' @param contentUrl URL for the actual bytes of the media object, for example the image file or video file.  \bold{Required}.
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param bitrate Bitrate in megabits per second (Mbit/s, Mb/s, Mbps).
#' @param caption The caption for this image.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param contentSize File size in megabits (Mbit, Mb).
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param embedUrl URL that can be used to embed the media on a web page via a specific media player.
#' @param format Media type (MIME type) as per http://www.iana.org/assignments/media-types/media-types.xhtml.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param thumbnail Thumbnail image of this image.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `ImageObject`
#' @seealso \code{\link{MediaObject}}
#' @export
ImageObject <- function(
  contentUrl,
  about,
  alternateNames,
  authors,
  bitrate,
  caption,
  comments,
  content,
  contentSize,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  embedUrl,
  format,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  parts,
  publisher,
  references,
  text,
  thumbnail,
  title,
  url,
  version
){
  self <- MediaObject(
    contentUrl = contentUrl,
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    bitrate = bitrate,
    comments = comments,
    content = content,
    contentSize = contentSize,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    embedUrl = embedUrl,
    format = format,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("ImageObject")
  self[["caption"]] <- check_property("ImageObject", "caption", FALSE, missing(caption), "character", caption)
  self[["thumbnail"]] <- check_property("ImageObject", "thumbnail", FALSE, missing(thumbnail), ImageObject, thumbnail)
  class(self) <- c(class(self), "ImageObject")
  self
}


#' A directive to include content from an external source (e.g. file, URL) or content.
#'
#' @name Include
#' @param source The source of the content, a URL or file path, or the content itself. \bold{Required}.
#' @param content The content to be included.
#' @param format Media type, typically expressed using a MIME format, of the source content.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `Include`
#' @seealso \code{\link{Entity}}
#' @export
Include <- function(
  source,
  content,
  format,
  id,
  meta
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Include")
  self[["source"]] <- check_property("Include", "source", TRUE, missing(source), "character", source)
  self[["content"]] <- check_property("Include", "content", FALSE, missing(content), Array(BlockContent), content)
  self[["format"]] <- check_property("Include", "format", FALSE, missing(format), "character", format)
  class(self) <- c(class(self), "Include")
  self
}


#' A validator specifying the constraints on a numeric node.
#'
#' @name NumberValidator
#' @param exclusiveMaximum The exclusive upper limit for a numeric node.
#' @param exclusiveMinimum The exclusive lower limit for a numeric node.
#' @param id The identifier for this item.
#' @param maximum The inclusive upper limit for a numeric node.
#' @param meta Metadata associated with this item.
#' @param minimum The inclusive lower limit for a numeric node.
#' @param multipleOf A number that a numeric node must be a multiple of.
#' @return A `list` of class `NumberValidator`
#' @seealso \code{\link{Entity}}
#' @export
NumberValidator <- function(
  exclusiveMaximum,
  exclusiveMinimum,
  id,
  maximum,
  meta,
  minimum,
  multipleOf
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("NumberValidator")
  self[["exclusiveMaximum"]] <- check_property("NumberValidator", "exclusiveMaximum", FALSE, missing(exclusiveMaximum), "numeric", exclusiveMaximum)
  self[["exclusiveMinimum"]] <- check_property("NumberValidator", "exclusiveMinimum", FALSE, missing(exclusiveMinimum), "numeric", exclusiveMinimum)
  self[["maximum"]] <- check_property("NumberValidator", "maximum", FALSE, missing(maximum), "numeric", maximum)
  self[["minimum"]] <- check_property("NumberValidator", "minimum", FALSE, missing(minimum), "numeric", minimum)
  self[["multipleOf"]] <- check_property("NumberValidator", "multipleOf", FALSE, missing(multipleOf), "numeric", multipleOf)
  class(self) <- c(class(self), "NumberValidator")
  self
}


#' A validator specifying the constraints on an integer node.
#'
#' @name IntegerValidator
#' @param exclusiveMaximum The exclusive upper limit for a numeric node.
#' @param exclusiveMinimum The exclusive lower limit for a numeric node.
#' @param id The identifier for this item.
#' @param maximum The inclusive upper limit for a numeric node.
#' @param meta Metadata associated with this item.
#' @param minimum The inclusive lower limit for a numeric node.
#' @param multipleOf A number that a numeric node must be a multiple of.
#' @return A `list` of class `IntegerValidator`
#' @seealso \code{\link{NumberValidator}}
#' @export
IntegerValidator <- function(
  exclusiveMaximum,
  exclusiveMinimum,
  id,
  maximum,
  meta,
  minimum,
  multipleOf
){
  self <- NumberValidator(
    exclusiveMaximum = exclusiveMaximum,
    exclusiveMinimum = exclusiveMinimum,
    id = id,
    maximum = maximum,
    meta = meta,
    minimum = minimum,
    multipleOf = multipleOf
  )
  self$type <- as_scalar("IntegerValidator")

  class(self) <- c(class(self), "IntegerValidator")
  self
}


#' A hyperlink to other pages, sections within the same document, resources, or any URL.
#'
#' @name Link
#' @param content The textual content of the link. \bold{Required}.
#' @param target The target of the link. \bold{Required}.
#' @param exportFrom A compilation directive giving the name of the variable to export to the link target.
#' @param id The identifier for this item.
#' @param importTo A compilation directive giving the name of the variable to import the link target as.
#' @param meta Metadata associated with this item.
#' @param relation The relation between the target and the current thing.
#' @param title A title for the link.
#' @return A `list` of class `Link`
#' @seealso \code{\link{Entity}}
#' @export
Link <- function(
  content,
  target,
  exportFrom,
  id,
  importTo,
  meta,
  relation,
  title
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Link")
  self[["content"]] <- check_property("Link", "content", TRUE, missing(content), Array(InlineContent), content)
  self[["target"]] <- check_property("Link", "target", TRUE, missing(target), "character", target)
  self[["exportFrom"]] <- check_property("Link", "exportFrom", FALSE, missing(exportFrom), "character", exportFrom)
  self[["importTo"]] <- check_property("Link", "importTo", FALSE, missing(importTo), "character", importTo)
  self[["relation"]] <- check_property("Link", "relation", FALSE, missing(relation), "character", relation)
  self[["title"]] <- check_property("Link", "title", FALSE, missing(title), "character", title)
  class(self) <- c(class(self), "Link")
  self
}


#' A list of items.
#'
#' @name List
#' @param items The items in the list \bold{Required}.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @param order Type of ordering.
#' @return A `list` of class `List`
#' @seealso \code{\link{Entity}}
#' @export
List <- function(
  items,
  id,
  meta,
  order
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("List")
  self[["items"]] <- check_property("List", "items", TRUE, missing(items), Array(ListItem), items)
  self[["order"]] <- check_property("List", "order", FALSE, missing(order), Enum("ascending", "descending", "unordered"), order)
  class(self) <- c(class(self), "List")
  self
}


#' A single item in a list.
#'
#' @name ListItem
#' @param alternateNames Alternate names (aliases) for the item.
#' @param content The content of the list item.
#' @param description A description of the item.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isChecked A flag to indicate if this list item is checked.
#' @param item The item represented by this list item.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param position The position of the item in a series or sequence of items.
#' @param url The URL of the item.
#' @return A `list` of class `ListItem`
#' @seealso \code{\link{Thing}}
#' @export
ListItem <- function(
  alternateNames,
  content,
  description,
  id,
  identifiers,
  images,
  isChecked,
  item,
  meta,
  name,
  position,
  url
){
  self <- Thing(
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    name = name,
    url = url
  )
  self$type <- as_scalar("ListItem")
  self[["content"]] <- check_property("ListItem", "content", FALSE, missing(content), Array(Node), content)
  self[["isChecked"]] <- check_property("ListItem", "isChecked", FALSE, missing(isChecked), "logical", isChecked)
  self[["item"]] <- check_property("ListItem", "item", FALSE, missing(item), Node, item)
  self[["position"]] <- check_property("ListItem", "position", FALSE, missing(position), "numeric", position)
  class(self) <- c(class(self), "ListItem")
  self
}


#' A mathematical variable or equation.
#'
#' @name Math
#' @param text The text of the equation in the language. \bold{Required}.
#' @param errors Errors that occurred when parsing the math equation.
#' @param id The identifier for this item.
#' @param mathLanguage The language used for the equation e.g tex, mathml, asciimath.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `Math`
#' @seealso \code{\link{Entity}}
#' @export
Math <- function(
  text,
  errors,
  id,
  mathLanguage,
  meta
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Math")
  self[["text"]] <- check_property("Math", "text", TRUE, missing(text), "character", text)
  self[["errors"]] <- check_property("Math", "errors", FALSE, missing(errors), Array("character"), errors)
  self[["mathLanguage"]] <- check_property("Math", "mathLanguage", FALSE, missing(mathLanguage), "character", mathLanguage)
  class(self) <- c(class(self), "Math")
  self
}


#' A block of math, e.g an equation, to be treated as block content.
#'
#' @name MathBlock
#' @param text The text of the equation in the language. \bold{Required}.
#' @param errors Errors that occurred when parsing the math equation.
#' @param id The identifier for this item.
#' @param mathLanguage The language used for the equation e.g tex, mathml, asciimath.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `MathBlock`
#' @seealso \code{\link{Math}}
#' @export
MathBlock <- function(
  text,
  errors,
  id,
  mathLanguage,
  meta
){
  self <- Math(
    text = text,
    errors = errors,
    id = id,
    mathLanguage = mathLanguage,
    meta = meta
  )
  self$type <- as_scalar("MathBlock")

  class(self) <- c(class(self), "MathBlock")
  self
}


#' A fragment of math, e.g a variable name, to be treated as inline content.
#'
#' @name MathFragment
#' @param text The text of the equation in the language. \bold{Required}.
#' @param errors Errors that occurred when parsing the math equation.
#' @param id The identifier for this item.
#' @param mathLanguage The language used for the equation e.g tex, mathml, asciimath.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `MathFragment`
#' @seealso \code{\link{Math}}
#' @export
MathFragment <- function(
  text,
  errors,
  id,
  mathLanguage,
  meta
){
  self <- Math(
    text = text,
    errors = errors,
    id = id,
    mathLanguage = mathLanguage,
    meta = meta
  )
  self$type <- as_scalar("MathFragment")

  class(self) <- c(class(self), "MathFragment")
  self
}


#' A monetary grant.
#'
#' @name MonetaryGrant
#' @param alternateNames Alternate names (aliases) for the item.
#' @param amounts The amount of money.
#' @param description A description of the item.
#' @param fundedItems Indicates an item funded or sponsored through a Grant.
#' @param funders A person or organization that supports (sponsors) something through some kind of financial contribution.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param sponsors A person or organization that supports a thing through a pledge, promise, or financial contribution.
#' @param url The URL of the item.
#' @return A `list` of class `MonetaryGrant`
#' @seealso \code{\link{Grant}}
#' @export
MonetaryGrant <- function(
  alternateNames,
  amounts,
  description,
  fundedItems,
  funders,
  id,
  identifiers,
  images,
  meta,
  name,
  sponsors,
  url
){
  self <- Grant(
    alternateNames = alternateNames,
    description = description,
    fundedItems = fundedItems,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    name = name,
    sponsors = sponsors,
    url = url
  )
  self$type <- as_scalar("MonetaryGrant")
  self[["amounts"]] <- check_property("MonetaryGrant", "amounts", FALSE, missing(amounts), "numeric", amounts)
  self[["funders"]] <- check_property("MonetaryGrant", "funders", FALSE, missing(funders), Array(Union(Person, Organization)), funders)
  class(self) <- c(class(self), "MonetaryGrant")
  self
}


#' Inline text that has a non-textual annotation.
#'
#' @name NontextualAnnotation
#' @param content The content that is marked. \bold{Required}.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `NontextualAnnotation`
#' @seealso \code{\link{Mark}}
#' @export
NontextualAnnotation <- function(
  content,
  id,
  meta
){
  self <- Mark(
    content = content,
    id = id,
    meta = meta
  )
  self$type <- as_scalar("NontextualAnnotation")

  class(self) <- c(class(self), "NontextualAnnotation")
  self
}


#' An organization such as a school, NGO, corporation, club, etc.
#'
#' @name Organization
#' @param address Postal address for the organization.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param brands Brands that the organization is connected with.
#' @param contactPoints Correspondence/Contact points for the organization.
#' @param departments Departments within the organization. For example, Department of Computer Science, Research & Development etc.
#' @param description A description of the item.
#' @param funders Organization(s) or person(s) funding the organization.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param legalName Legal name for the Organization. Should only include letters and spaces.
#' @param logo The logo of the organization.
#' @param members Person(s) or organization(s) who are members of this organization.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parentOrganization Entity that the Organization is a part of. For example, parentOrganization to a department is a university.
#' @param url The URL of the item.
#' @return A `list` of class `Organization`
#' @seealso \code{\link{Thing}}
#' @export
Organization <- function(
  address,
  alternateNames,
  brands,
  contactPoints,
  departments,
  description,
  funders,
  id,
  identifiers,
  images,
  legalName,
  logo,
  members,
  meta,
  name,
  parentOrganization,
  url
){
  self <- Thing(
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    name = name,
    url = url
  )
  self$type <- as_scalar("Organization")
  self[["address"]] <- check_property("Organization", "address", FALSE, missing(address), Union("character", PostalAddress), address)
  self[["brands"]] <- check_property("Organization", "brands", FALSE, missing(brands), Array(Brand), brands)
  self[["contactPoints"]] <- check_property("Organization", "contactPoints", FALSE, missing(contactPoints), Array(ContactPoint), contactPoints)
  self[["departments"]] <- check_property("Organization", "departments", FALSE, missing(departments), Array(Organization), departments)
  self[["funders"]] <- check_property("Organization", "funders", FALSE, missing(funders), Array(Union(Organization, Person)), funders)
  self[["legalName"]] <- check_property("Organization", "legalName", FALSE, missing(legalName), "character", legalName)
  self[["logo"]] <- check_property("Organization", "logo", FALSE, missing(logo), Union("character", ImageObject), logo)
  self[["members"]] <- check_property("Organization", "members", FALSE, missing(members), Array(Union(Organization, Person)), members)
  self[["parentOrganization"]] <- check_property("Organization", "parentOrganization", FALSE, missing(parentOrganization), Organization, parentOrganization)
  class(self) <- c(class(self), "Organization")
  self
}


#' Paragraph
#'
#' @name Paragraph
#' @param content The contents of the paragraph. \bold{Required}.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `Paragraph`
#' @seealso \code{\link{Entity}}
#' @export
Paragraph <- function(
  content,
  id,
  meta
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Paragraph")
  self[["content"]] <- check_property("Paragraph", "content", TRUE, missing(content), Array(InlineContent), content)
  class(self) <- c(class(self), "Paragraph")
  self
}


#' A variable representing a name / value pair.
#'
#' @name Variable
#' @param name The name of the variable. \bold{Required}.
#' @param id The identifier for this item.
#' @param isReadonly Whether or not a property is mutable. Default is false.
#' @param meta Metadata associated with this item.
#' @param validator The validator that the value is validated against.
#' @param value The value of the variable.
#' @return A `list` of class `Variable`
#' @seealso \code{\link{Entity}}
#' @export
Variable <- function(
  name,
  id,
  isReadonly,
  meta,
  validator,
  value
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Variable")
  self[["name"]] <- check_property("Variable", "name", TRUE, missing(name), "character", name)
  self[["isReadonly"]] <- check_property("Variable", "isReadonly", FALSE, missing(isReadonly), "logical", isReadonly)
  self[["validator"]] <- check_property("Variable", "validator", FALSE, missing(validator), ValidatorTypes, validator)
  self[["value"]] <- check_property("Variable", "value", FALSE, missing(value), Node, value)
  class(self) <- c(class(self), "Variable")
  self
}


#' A parameter that can be set and used in evaluated code.
#'
#' @name Parameter
#' @param name The name of the variable. \bold{Required}.
#' @param default The default value of the parameter.
#' @param id The identifier for this item.
#' @param isExtensible Indicates that this parameter is variadic and can accept multiple named arguments.
#' @param isReadonly Whether or not a property is mutable. Default is false.
#' @param isRequired Is this parameter required, if not it should have a default or default is assumed to be null.
#' @param isVariadic Indicates that this parameter is variadic and can accept multiple arguments.
#' @param meta Metadata associated with this item.
#' @param validator The validator that the value is validated against.
#' @param value The value of the variable.
#' @return A `list` of class `Parameter`
#' @seealso \code{\link{Variable}}
#' @export
Parameter <- function(
  name,
  default,
  id,
  isExtensible,
  isReadonly,
  isRequired,
  isVariadic,
  meta,
  validator,
  value
){
  self <- Variable(
    name = name,
    id = id,
    isReadonly = isReadonly,
    meta = meta,
    validator = validator,
    value = value
  )
  self$type <- as_scalar("Parameter")
  self[["default"]] <- check_property("Parameter", "default", FALSE, missing(default), Node, default)
  self[["isExtensible"]] <- check_property("Parameter", "isExtensible", FALSE, missing(isExtensible), "logical", isExtensible)
  self[["isRequired"]] <- check_property("Parameter", "isRequired", FALSE, missing(isRequired), "logical", isRequired)
  self[["isVariadic"]] <- check_property("Parameter", "isVariadic", FALSE, missing(isVariadic), "logical", isVariadic)
  class(self) <- c(class(self), "Parameter")
  self
}


#' A periodical publication.
#'
#' @name Periodical
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateEnd The date this Periodical ceased publication.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param dateStart The date this Periodical was first published.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param issns The International Standard Serial Number(s) (ISSN) that identifies this serial publication.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `Periodical`
#' @seealso \code{\link{CreativeWork}}
#' @export
Periodical <- function(
  about,
  alternateNames,
  authors,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateEnd,
  dateModified,
  datePublished,
  dateReceived,
  dateStart,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  issns,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  parts,
  publisher,
  references,
  text,
  title,
  url,
  version
){
  self <- CreativeWork(
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    comments = comments,
    content = content,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("Periodical")
  self[["dateEnd"]] <- check_property("Periodical", "dateEnd", FALSE, missing(dateEnd), Union(Date, "character"), dateEnd)
  self[["dateStart"]] <- check_property("Periodical", "dateStart", FALSE, missing(dateStart), Union(Date, "character"), dateStart)
  self[["issns"]] <- check_property("Periodical", "issns", FALSE, missing(issns), Array("character"), issns)
  class(self) <- c(class(self), "Periodical")
  self
}


#' A person (alive, dead, undead, or fictional).
#'
#' @name Person
#' @param address Postal address for the person.
#' @param affiliations Organizations that the person is affiliated with.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param description A description of the item.
#' @param emails Email addresses for the person.
#' @param familyNames Family name. In the U.S., the last name of a person.
#' @param funders A person or organization that supports (sponsors) something through some kind of financial contribution.
#' @param givenNames Given name. In the U.S., the first name of a person.
#' @param honorificPrefix An honorific prefix preceding a person's name such as Dr/Mrs/Mr.
#' @param honorificSuffix An honorific suffix after a person's name such as MD/PhD/MSCSW.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param jobTitle The job title of the person (for example, Financial Manager).
#' @param memberOf An organization (or program membership) to which this person belongs.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param telephoneNumbers Telephone numbers for the person.
#' @param url The URL of the item.
#' @return A `list` of class `Person`
#' @seealso \code{\link{Thing}}
#' @export
#' @examples
#' Person(
#'   honorificPrefix = "Dr",
#'   givenNames = list("Jane", "J"),
#'   familyNames = list("Jamieson")
#' )
Person <- function(
  address,
  affiliations,
  alternateNames,
  description,
  emails,
  familyNames,
  funders,
  givenNames,
  honorificPrefix,
  honorificSuffix,
  id,
  identifiers,
  images,
  jobTitle,
  memberOf,
  meta,
  name,
  telephoneNumbers,
  url
){
  self <- Thing(
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    name = name,
    url = url
  )
  self$type <- as_scalar("Person")
  self[["address"]] <- check_property("Person", "address", FALSE, missing(address), Union("character", PostalAddress), address)
  self[["affiliations"]] <- check_property("Person", "affiliations", FALSE, missing(affiliations), Array(Organization), affiliations)
  self[["emails"]] <- check_property("Person", "emails", FALSE, missing(emails), Array("character"), emails)
  self[["familyNames"]] <- check_property("Person", "familyNames", FALSE, missing(familyNames), Array("character"), familyNames)
  self[["funders"]] <- check_property("Person", "funders", FALSE, missing(funders), Array(Union(Organization, Person)), funders)
  self[["givenNames"]] <- check_property("Person", "givenNames", FALSE, missing(givenNames), Array("character"), givenNames)
  self[["honorificPrefix"]] <- check_property("Person", "honorificPrefix", FALSE, missing(honorificPrefix), "character", honorificPrefix)
  self[["honorificSuffix"]] <- check_property("Person", "honorificSuffix", FALSE, missing(honorificSuffix), "character", honorificSuffix)
  self[["jobTitle"]] <- check_property("Person", "jobTitle", FALSE, missing(jobTitle), "character", jobTitle)
  self[["memberOf"]] <- check_property("Person", "memberOf", FALSE, missing(memberOf), Array(Organization), memberOf)
  self[["telephoneNumbers"]] <- check_property("Person", "telephoneNumbers", FALSE, missing(telephoneNumbers), Array("character"), telephoneNumbers)
  class(self) <- c(class(self), "Person")
  self
}


#' A physical mailing address.
#'
#' @name PostalAddress
#' @param addressCountry The country.
#' @param addressLocality The locality in which the street address is, and which is in the region.
#' @param addressRegion The region in which the locality is, and which is in the country.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param availableLanguages Languages (human not programming) in which it is possible to communicate with the organization/department etc.
#' @param description A description of the item.
#' @param emails Email address for correspondence.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param postOfficeBoxNumber The post office box number.
#' @param postalCode The postal code.
#' @param streetAddress The street address.
#' @param telephoneNumbers Telephone numbers for the contact point.
#' @param url The URL of the item.
#' @return A `list` of class `PostalAddress`
#' @seealso \code{\link{ContactPoint}}
#' @export
PostalAddress <- function(
  addressCountry,
  addressLocality,
  addressRegion,
  alternateNames,
  availableLanguages,
  description,
  emails,
  id,
  identifiers,
  images,
  meta,
  name,
  postOfficeBoxNumber,
  postalCode,
  streetAddress,
  telephoneNumbers,
  url
){
  self <- ContactPoint(
    alternateNames = alternateNames,
    availableLanguages = availableLanguages,
    description = description,
    emails = emails,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    name = name,
    telephoneNumbers = telephoneNumbers,
    url = url
  )
  self$type <- as_scalar("PostalAddress")
  self[["addressCountry"]] <- check_property("PostalAddress", "addressCountry", FALSE, missing(addressCountry), "character", addressCountry)
  self[["addressLocality"]] <- check_property("PostalAddress", "addressLocality", FALSE, missing(addressLocality), "character", addressLocality)
  self[["addressRegion"]] <- check_property("PostalAddress", "addressRegion", FALSE, missing(addressRegion), "character", addressRegion)
  self[["postOfficeBoxNumber"]] <- check_property("PostalAddress", "postOfficeBoxNumber", FALSE, missing(postOfficeBoxNumber), "character", postOfficeBoxNumber)
  self[["postalCode"]] <- check_property("PostalAddress", "postalCode", FALSE, missing(postalCode), "character", postalCode)
  self[["streetAddress"]] <- check_property("PostalAddress", "streetAddress", FALSE, missing(streetAddress), "character", streetAddress)
  class(self) <- c(class(self), "PostalAddress")
  self
}


#' Any offered product or service. For example, a pair of shoes; a haircut; or an episode of a TV show streamed online.
#'
#' @name Product
#' @param alternateNames Alternate names (aliases) for the item.
#' @param brands Brands that the product is labelled with.
#' @param description A description of the item.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param logo The logo of the product.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param productID Product identification code.
#' @param url The URL of the item.
#' @return A `list` of class `Product`
#' @seealso \code{\link{Thing}}
#' @export
Product <- function(
  alternateNames,
  brands,
  description,
  id,
  identifiers,
  images,
  logo,
  meta,
  name,
  productID,
  url
){
  self <- Thing(
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    name = name,
    url = url
  )
  self$type <- as_scalar("Product")
  self[["brands"]] <- check_property("Product", "brands", FALSE, missing(brands), Array(Brand), brands)
  self[["logo"]] <- check_property("Product", "logo", FALSE, missing(logo), Union("character", ImageObject), logo)
  self[["productID"]] <- check_property("Product", "productID", FALSE, missing(productID), "character", productID)
  class(self) <- c(class(self), "Product")
  self
}


#' A property-value pair.
#'
#' @name PropertyValue
#' @param value The value of the property. \bold{Required}.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param description A description of the item.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param propertyID A commonly used identifier for the characteristic represented by the property.
#' @param url The URL of the item.
#' @return A `list` of class `PropertyValue`
#' @seealso \code{\link{Thing}}
#' @export
PropertyValue <- function(
  value,
  alternateNames,
  description,
  id,
  identifiers,
  images,
  meta,
  name,
  propertyID,
  url
){
  self <- Thing(
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    name = name,
    url = url
  )
  self$type <- as_scalar("PropertyValue")
  self[["value"]] <- check_property("PropertyValue", "value", TRUE, missing(value), Node, value)
  self[["propertyID"]] <- check_property("PropertyValue", "propertyID", FALSE, missing(propertyID), "character", propertyID)
  class(self) <- c(class(self), "PropertyValue")
  self
}


#' A part of a successively published publication such as a periodical or publication volume, often numbered.
#'
#' @name PublicationIssue
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param issueNumber Identifies the issue of publication; for example, "iii" or "2".
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param pageEnd The page on which the issue ends; for example "138" or "xvi".
#' @param pageStart The page on which the issue starts; for example "135" or "xiii".
#' @param pagination Any description of pages that is not separated into pageStart and pageEnd; for example, "1-6, 9, 55".
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `PublicationIssue`
#' @seealso \code{\link{CreativeWork}}
#' @export
PublicationIssue <- function(
  about,
  alternateNames,
  authors,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  issueNumber,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  pageEnd,
  pageStart,
  pagination,
  parts,
  publisher,
  references,
  text,
  title,
  url,
  version
){
  self <- CreativeWork(
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    comments = comments,
    content = content,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("PublicationIssue")
  self[["issueNumber"]] <- check_property("PublicationIssue", "issueNumber", FALSE, missing(issueNumber), Union("numeric", "character"), issueNumber)
  self[["pageEnd"]] <- check_property("PublicationIssue", "pageEnd", FALSE, missing(pageEnd), Union("numeric", "character"), pageEnd)
  self[["pageStart"]] <- check_property("PublicationIssue", "pageStart", FALSE, missing(pageStart), Union("numeric", "character"), pageStart)
  self[["pagination"]] <- check_property("PublicationIssue", "pagination", FALSE, missing(pagination), "character", pagination)
  class(self) <- c(class(self), "PublicationIssue")
  self
}


#' A part of a successively published publication such as a periodical or multi-volume work.
#'
#' @name PublicationVolume
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param pageEnd The page on which the volume ends; for example "138" or "xvi".
#' @param pageStart The page on which the volume starts; for example "135" or "xiii".
#' @param pagination Any description of pages that is not separated into pageStart and pageEnd; for example, "1-6, 9, 55".
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @param volumeNumber Identifies the volume of publication or multi-part work; for example, "iii" or "2".
#' @return A `list` of class `PublicationVolume`
#' @seealso \code{\link{CreativeWork}}
#' @export
PublicationVolume <- function(
  about,
  alternateNames,
  authors,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  pageEnd,
  pageStart,
  pagination,
  parts,
  publisher,
  references,
  text,
  title,
  url,
  version,
  volumeNumber
){
  self <- CreativeWork(
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    comments = comments,
    content = content,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("PublicationVolume")
  self[["pageEnd"]] <- check_property("PublicationVolume", "pageEnd", FALSE, missing(pageEnd), Union("numeric", "character"), pageEnd)
  self[["pageStart"]] <- check_property("PublicationVolume", "pageStart", FALSE, missing(pageStart), Union("numeric", "character"), pageStart)
  self[["pagination"]] <- check_property("PublicationVolume", "pagination", FALSE, missing(pagination), "character", pagination)
  self[["volumeNumber"]] <- check_property("PublicationVolume", "volumeNumber", FALSE, missing(volumeNumber), Union("numeric", "character"), volumeNumber)
  class(self) <- c(class(self), "PublicationVolume")
  self
}


#' Inline, quoted content.
#'
#' @name Quote
#' @param content The content that is marked. \bold{Required}.
#' @param cite The source of the quote.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `Quote`
#' @seealso \code{\link{Mark}}
#' @export
Quote <- function(
  content,
  cite,
  id,
  meta
){
  self <- Mark(
    content = content,
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Quote")
  self[["cite"]] <- check_property("Quote", "cite", FALSE, missing(cite), Union(Cite, "character"), cite)
  class(self) <- c(class(self), "Quote")
  self
}


#' A section quoted from somewhere else.
#'
#' @name QuoteBlock
#' @param content The content of the quote. \bold{Required}.
#' @param cite The source of the quote.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `QuoteBlock`
#' @seealso \code{\link{Entity}}
#' @export
QuoteBlock <- function(
  content,
  cite,
  id,
  meta
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("QuoteBlock")
  self[["content"]] <- check_property("QuoteBlock", "content", TRUE, missing(content), Array(BlockContent), content)
  self[["cite"]] <- check_property("QuoteBlock", "cite", FALSE, missing(cite), Union(Cite, "character"), cite)
  class(self) <- c(class(self), "QuoteBlock")
  self
}


#' A review of an item, e.g of an Article, or SoftwareSourceCode.
#'
#' @name Review
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param itemReviewed The item that is being reviewed.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param reviewAspect The part or facet of the item that is being reviewed.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `Review`
#' @seealso \code{\link{CreativeWork}}
#' @export
Review <- function(
  about,
  alternateNames,
  authors,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  itemReviewed,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  parts,
  publisher,
  references,
  reviewAspect,
  text,
  title,
  url,
  version
){
  self <- CreativeWork(
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    comments = comments,
    content = content,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("Review")
  self[["itemReviewed"]] <- check_property("Review", "itemReviewed", FALSE, missing(itemReviewed), Thing, itemReviewed)
  self[["reviewAspect"]] <- check_property("Review", "reviewAspect", FALSE, missing(reviewAspect), "character", reviewAspect)
  class(self) <- c(class(self), "Review")
  self
}


#' A software application.
#'
#' @name SoftwareApplication
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param softwareRequirements Requirements for application, including shared libraries that are not included in the application distribution.
#' @param softwareVersion Version of the software.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `SoftwareApplication`
#' @seealso \code{\link{CreativeWork}}
#' @export
SoftwareApplication <- function(
  about,
  alternateNames,
  authors,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  parts,
  publisher,
  references,
  softwareRequirements,
  softwareVersion,
  text,
  title,
  url,
  version
){
  self <- CreativeWork(
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    comments = comments,
    content = content,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("SoftwareApplication")
  self[["softwareRequirements"]] <- check_property("SoftwareApplication", "softwareRequirements", FALSE, missing(softwareRequirements), Array(SoftwareApplication), softwareRequirements)
  self[["softwareVersion"]] <- check_property("SoftwareApplication", "softwareVersion", FALSE, missing(softwareVersion), "character", softwareVersion)
  class(self) <- c(class(self), "SoftwareApplication")
  self
}


#' A computational environment.
#'
#' @name SoftwareEnvironment
#' @param name The name of the item. \bold{Required}.
#' @param adds The packages that this environment adds to the base environments listed under `extends` (if any).,
#' @param alternateNames Alternate names (aliases) for the item.
#' @param description A description of the item.
#' @param extends Other environments that this environment extends by adding or removing packages.,
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param meta Metadata associated with this item.
#' @param removes The packages that this environment removes from the base environments listed under `extends` (if any).,
#' @param url The URL of the item.
#' @return A `list` of class `SoftwareEnvironment`
#' @seealso \code{\link{Thing}}
#' @export
SoftwareEnvironment <- function(
  name,
  adds,
  alternateNames,
  description,
  extends,
  id,
  identifiers,
  images,
  meta,
  removes,
  url
){
  self <- Thing(
    name = name,
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    url = url
  )
  self$type <- as_scalar("SoftwareEnvironment")
  self[["name"]] <- check_property("SoftwareEnvironment", "name", TRUE, missing(name), "character", name)
  self[["adds"]] <- check_property("SoftwareEnvironment", "adds", FALSE, missing(adds), Array(SoftwareSourceCode), adds)
  self[["extends"]] <- check_property("SoftwareEnvironment", "extends", FALSE, missing(extends), Array(SoftwareEnvironment), extends)
  self[["removes"]] <- check_property("SoftwareEnvironment", "removes", FALSE, missing(removes), Array(SoftwareSourceCode), removes)
  class(self) <- c(class(self), "SoftwareEnvironment")
  self
}


#' Definition of a compute session, including its software and compute resource requirements and status.
#'
#' @name SoftwareSession
#' @param alternateNames Alternate names (aliases) for the item.
#' @param clientsLimit The maximum number of concurrent clients the session is limited to.
#' @param clientsRequest The maximum number of concurrent clients requested for the session.
#' @param cpuLimit The amount of CPU the session is limited to.
#' @param cpuRequest The amount of CPU requested for the session.
#' @param dateEnd The date-time that the session ended.
#' @param dateStart The date-time that the session began.
#' @param description A description of the item.
#' @param durationLimit The maximum duration (seconds) the session is limited to.
#' @param durationRequest The maximum duration (seconds) requested for the session.
#' @param environment The software environment to execute this session in.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param memoryLimit The amount of memory that the session is limited to.
#' @param memoryRequest The amount of memory requested for the session.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param networkTransferLimit The amount of network data transfer (GiB) that the session is limited to.
#' @param networkTransferRequest The amount of network data transfer (GiB) requested for the session.
#' @param status The status of the session (starting, stopped, etc).
#' @param timeoutLimit The inactivity timeout (seconds) the session is limited to.
#' @param timeoutRequest The inactivity timeout (seconds) requested for the session.
#' @param url The URL of the item.
#' @param volumeMounts Volumes to mount in the session.
#' @return A `list` of class `SoftwareSession`
#' @seealso \code{\link{Thing}}
#' @export
SoftwareSession <- function(
  alternateNames,
  clientsLimit,
  clientsRequest,
  cpuLimit,
  cpuRequest,
  dateEnd,
  dateStart,
  description,
  durationLimit,
  durationRequest,
  environment,
  id,
  identifiers,
  images,
  memoryLimit,
  memoryRequest,
  meta,
  name,
  networkTransferLimit,
  networkTransferRequest,
  status,
  timeoutLimit,
  timeoutRequest,
  url,
  volumeMounts
){
  self <- Thing(
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    name = name,
    url = url
  )
  self$type <- as_scalar("SoftwareSession")
  self[["clientsLimit"]] <- check_property("SoftwareSession", "clientsLimit", FALSE, missing(clientsLimit), "numeric", clientsLimit)
  self[["clientsRequest"]] <- check_property("SoftwareSession", "clientsRequest", FALSE, missing(clientsRequest), "numeric", clientsRequest)
  self[["cpuLimit"]] <- check_property("SoftwareSession", "cpuLimit", FALSE, missing(cpuLimit), "numeric", cpuLimit)
  self[["cpuRequest"]] <- check_property("SoftwareSession", "cpuRequest", FALSE, missing(cpuRequest), "numeric", cpuRequest)
  self[["dateEnd"]] <- check_property("SoftwareSession", "dateEnd", FALSE, missing(dateEnd), Union(Date, "character"), dateEnd)
  self[["dateStart"]] <- check_property("SoftwareSession", "dateStart", FALSE, missing(dateStart), Union(Date, "character"), dateStart)
  self[["durationLimit"]] <- check_property("SoftwareSession", "durationLimit", FALSE, missing(durationLimit), "numeric", durationLimit)
  self[["durationRequest"]] <- check_property("SoftwareSession", "durationRequest", FALSE, missing(durationRequest), "numeric", durationRequest)
  self[["environment"]] <- check_property("SoftwareSession", "environment", FALSE, missing(environment), SoftwareEnvironment, environment)
  self[["memoryLimit"]] <- check_property("SoftwareSession", "memoryLimit", FALSE, missing(memoryLimit), "numeric", memoryLimit)
  self[["memoryRequest"]] <- check_property("SoftwareSession", "memoryRequest", FALSE, missing(memoryRequest), "numeric", memoryRequest)
  self[["networkTransferLimit"]] <- check_property("SoftwareSession", "networkTransferLimit", FALSE, missing(networkTransferLimit), "numeric", networkTransferLimit)
  self[["networkTransferRequest"]] <- check_property("SoftwareSession", "networkTransferRequest", FALSE, missing(networkTransferRequest), "numeric", networkTransferRequest)
  self[["status"]] <- check_property("SoftwareSession", "status", FALSE, missing(status), Enum("unknown", "starting", "started", "stopping", "stopped", "failed"), status)
  self[["timeoutLimit"]] <- check_property("SoftwareSession", "timeoutLimit", FALSE, missing(timeoutLimit), "numeric", timeoutLimit)
  self[["timeoutRequest"]] <- check_property("SoftwareSession", "timeoutRequest", FALSE, missing(timeoutRequest), "numeric", timeoutRequest)
  self[["volumeMounts"]] <- check_property("SoftwareSession", "volumeMounts", FALSE, missing(volumeMounts), Array(VolumeMount), volumeMounts)
  class(self) <- c(class(self), "SoftwareSession")
  self
}


#' Computer programming source code. Example: Full (compile ready) solutions, code snippet samples, scripts, templates.
#'
#' @name SoftwareSourceCode
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param codeRepository Link to the repository where the un-compiled, human readable code and related code is located.
#' @param codeSampleType What type of code sample: full (compile ready) solution, code snippet, inline code, scripts, template.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param programmingLanguage The computer programming language.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param runtimePlatform Runtime platform or script interpreter dependencies (Example - Java v1, Python2.3, .Net Framework 3.0).
#' @param softwareRequirements Dependency requirements for the software.
#' @param targetProducts Target operating system or product to which the code applies.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `SoftwareSourceCode`
#' @seealso \code{\link{CreativeWork}}
#' @export
SoftwareSourceCode <- function(
  about,
  alternateNames,
  authors,
  codeRepository,
  codeSampleType,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  parts,
  programmingLanguage,
  publisher,
  references,
  runtimePlatform,
  softwareRequirements,
  targetProducts,
  text,
  title,
  url,
  version
){
  self <- CreativeWork(
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    comments = comments,
    content = content,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("SoftwareSourceCode")
  self[["codeRepository"]] <- check_property("SoftwareSourceCode", "codeRepository", FALSE, missing(codeRepository), "character", codeRepository)
  self[["codeSampleType"]] <- check_property("SoftwareSourceCode", "codeSampleType", FALSE, missing(codeSampleType), "character", codeSampleType)
  self[["programmingLanguage"]] <- check_property("SoftwareSourceCode", "programmingLanguage", FALSE, missing(programmingLanguage), "character", programmingLanguage)
  self[["runtimePlatform"]] <- check_property("SoftwareSourceCode", "runtimePlatform", FALSE, missing(runtimePlatform), Array("character"), runtimePlatform)
  self[["softwareRequirements"]] <- check_property("SoftwareSourceCode", "softwareRequirements", FALSE, missing(softwareRequirements), Array(Union(SoftwareSourceCode, SoftwareApplication, "character")), softwareRequirements)
  self[["targetProducts"]] <- check_property("SoftwareSourceCode", "targetProducts", FALSE, missing(targetProducts), Array(SoftwareApplication), targetProducts)
  class(self) <- c(class(self), "SoftwareSourceCode")
  self
}


#' A schema specifying constraints on a string node.
#'
#' @name StringValidator
#' @param id The identifier for this item.
#' @param maxLength The maximum length for a string node.
#' @param meta Metadata associated with this item.
#' @param minLength The minimum length for a string node.
#' @param pattern A regular expression that a string node must match.
#' @return A `list` of class `StringValidator`
#' @seealso \code{\link{Entity}}
#' @export
StringValidator <- function(
  id,
  maxLength,
  meta,
  minLength,
  pattern
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("StringValidator")
  self[["maxLength"]] <- check_property("StringValidator", "maxLength", FALSE, missing(maxLength), "numeric", maxLength)
  self[["minLength"]] <- check_property("StringValidator", "minLength", FALSE, missing(minLength), "numeric", minLength)
  self[["pattern"]] <- check_property("StringValidator", "pattern", FALSE, missing(pattern), "character", pattern)
  class(self) <- c(class(self), "StringValidator")
  self
}


#' Strongly emphasised content.
#'
#' @name Strong
#' @param content The content that is marked. \bold{Required}.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `Strong`
#' @seealso \code{\link{Mark}}
#' @export
Strong <- function(
  content,
  id,
  meta
){
  self <- Mark(
    content = content,
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Strong")

  class(self) <- c(class(self), "Strong")
  self
}


#' Subscripted content.
#'
#' @name Subscript
#' @param content The content that is marked. \bold{Required}.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `Subscript`
#' @seealso \code{\link{Mark}}
#' @export
Subscript <- function(
  content,
  id,
  meta
){
  self <- Mark(
    content = content,
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Subscript")

  class(self) <- c(class(self), "Subscript")
  self
}


#' Superscripted content.
#'
#' @name Superscript
#' @param content The content that is marked. \bold{Required}.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `Superscript`
#' @seealso \code{\link{Mark}}
#' @export
Superscript <- function(
  content,
  id,
  meta
){
  self <- Mark(
    content = content,
    id = id,
    meta = meta
  )
  self$type <- as_scalar("Superscript")

  class(self) <- c(class(self), "Superscript")
  self
}


#' A table.
#'
#' @name Table
#' @param rows Rows of cells in the table.  \bold{Required}.
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param caption A caption for the table.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param label A short label for the table.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param title The title of the creative work.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `Table`
#' @seealso \code{\link{CreativeWork}}
#' @export
Table <- function(
  rows,
  about,
  alternateNames,
  authors,
  caption,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  label,
  licenses,
  maintainers,
  meta,
  name,
  parts,
  publisher,
  references,
  text,
  title,
  url,
  version
){
  self <- CreativeWork(
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    comments = comments,
    content = content,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("Table")
  self[["rows"]] <- check_property("Table", "rows", TRUE, missing(rows), Array(TableRow), rows)
  self[["caption"]] <- check_property("Table", "caption", FALSE, missing(caption), Union("character", Array(Node)), caption)
  self[["label"]] <- check_property("Table", "label", FALSE, missing(label), "character", label)
  class(self) <- c(class(self), "Table")
  self
}


#' A cell within a `Table`.
#'
#' @name TableCell
#' @param content Contents of the table cell. \bold{Required}.
#' @param cellType Indicates whether the cell is a header or data.
#' @param colspan How many columns the cell extends.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @param name The name of the cell.
#' @param rowspan How many columns the cell extends.
#' @return A `list` of class `TableCell`
#' @seealso \code{\link{Entity}}
#' @export
TableCell <- function(
  content,
  cellType,
  colspan,
  id,
  meta,
  name,
  rowspan
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("TableCell")
  self[["content"]] <- check_property("TableCell", "content", TRUE, missing(content), Array(Node), content)
  self[["cellType"]] <- check_property("TableCell", "cellType", FALSE, missing(cellType), Enum("data", "header"), cellType)
  self[["colspan"]] <- check_property("TableCell", "colspan", FALSE, missing(colspan), "numeric", colspan)
  self[["name"]] <- check_property("TableCell", "name", FALSE, missing(name), "character", name)
  self[["rowspan"]] <- check_property("TableCell", "rowspan", FALSE, missing(rowspan), "numeric", rowspan)
  class(self) <- c(class(self), "TableCell")
  self
}


#' A row within a Table.
#'
#' @name TableRow
#' @param cells An array of cells in the row. \bold{Required}.
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @param rowType If present, indicates that all cells in this row should be treated as header cells.
#' @return A `list` of class `TableRow`
#' @seealso \code{\link{Entity}}
#' @export
TableRow <- function(
  cells,
  id,
  meta,
  rowType
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("TableRow")
  self[["cells"]] <- check_property("TableRow", "cells", TRUE, missing(cells), Array(TableCell), cells)
  self[["rowType"]] <- check_property("TableRow", "rowType", FALSE, missing(rowType), Enum("header", "footer"), rowType)
  class(self) <- c(class(self), "TableRow")
  self
}


#' A thematic break, such as a scene change in a story, a transition to another topic, or a new document.
#'
#' @name ThematicBreak
#' @param id The identifier for this item.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `ThematicBreak`
#' @seealso \code{\link{Entity}}
#' @export
ThematicBreak <- function(
  id,
  meta
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("ThematicBreak")

  class(self) <- c(class(self), "ThematicBreak")
  self
}


#' A validator specifying constraints on an array of heterogeneous items.
#'
#' @name TupleValidator
#' @param id The identifier for this item.
#' @param items An array of validators specifying the constraints on each successive item in the array.
#' @param meta Metadata associated with this item.
#' @return A `list` of class `TupleValidator`
#' @seealso \code{\link{Entity}}
#' @export
TupleValidator <- function(
  id,
  items,
  meta
){
  self <- Entity(
    id = id,
    meta = meta
  )
  self$type <- as_scalar("TupleValidator")
  self[["items"]] <- check_property("TupleValidator", "items", FALSE, missing(items), Array(ValidatorTypes), items)
  class(self) <- c(class(self), "TupleValidator")
  self
}


#' A video file.
#'
#' @name VideoObject
#' @param contentUrl URL for the actual bytes of the media object, for example the image file or video file.  \bold{Required}.
#' @param about The subject matter of the content.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param authors The authors of this creative work.
#' @param bitrate Bitrate in megabits per second (Mbit/s, Mb/s, Mbps).
#' @param caption The caption for this video recording.
#' @param comments Comments about this creative work.
#' @param content The structured content of this creative work c.f. property `text`.
#' @param contentSize File size in megabits (Mbit, Mb).
#' @param dateAccepted Date/time of acceptance.
#' @param dateCreated Date/time of creation.
#' @param dateModified Date/time of most recent modification.
#' @param datePublished Date of first publication.
#' @param dateReceived Date/time that work was received.
#' @param description A description of the item.
#' @param editors People who edited the `CreativeWork`.
#' @param embedUrl URL that can be used to embed the media on a web page via a specific media player.
#' @param format Media type (MIME type) as per http://www.iana.org/assignments/media-types/media-types.xhtml.
#' @param fundedBy Grants that funded the `CreativeWork`; reverse of `fundedItems`.
#' @param funders People or organizations that funded the `CreativeWork`.
#' @param genre Genre of the creative work, broadcast channel or group.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param isPartOf An item or other CreativeWork that this CreativeWork is a part of.
#' @param keywords Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
#' @param licenses License documents that applies to this content, typically indicated by URL.
#' @param maintainers The people or organizations who maintain this CreativeWork.
#' @param meta Metadata associated with this item.
#' @param name The name of the item.
#' @param parts Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
#' @param publisher A publisher of the CreativeWork.
#' @param references References to other creative works, such as another publication, web page, scholarly article, etc.
#' @param text The textual content of this creative work.
#' @param thumbnail Thumbnail image of this video recording.
#' @param title The title of the creative work.
#' @param transcript The transcript of this video recording.
#' @param url The URL of the item.
#' @param version The version of the creative work.
#' @return A `list` of class `VideoObject`
#' @seealso \code{\link{MediaObject}}
#' @export
VideoObject <- function(
  contentUrl,
  about,
  alternateNames,
  authors,
  bitrate,
  caption,
  comments,
  content,
  contentSize,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  embedUrl,
  format,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  parts,
  publisher,
  references,
  text,
  thumbnail,
  title,
  transcript,
  url,
  version
){
  self <- MediaObject(
    contentUrl = contentUrl,
    about = about,
    alternateNames = alternateNames,
    authors = authors,
    bitrate = bitrate,
    comments = comments,
    content = content,
    contentSize = contentSize,
    dateAccepted = dateAccepted,
    dateCreated = dateCreated,
    dateModified = dateModified,
    datePublished = datePublished,
    dateReceived = dateReceived,
    description = description,
    editors = editors,
    embedUrl = embedUrl,
    format = format,
    fundedBy = fundedBy,
    funders = funders,
    genre = genre,
    id = id,
    identifiers = identifiers,
    images = images,
    isPartOf = isPartOf,
    keywords = keywords,
    licenses = licenses,
    maintainers = maintainers,
    meta = meta,
    name = name,
    parts = parts,
    publisher = publisher,
    references = references,
    text = text,
    title = title,
    url = url,
    version = version
  )
  self$type <- as_scalar("VideoObject")
  self[["caption"]] <- check_property("VideoObject", "caption", FALSE, missing(caption), "character", caption)
  self[["thumbnail"]] <- check_property("VideoObject", "thumbnail", FALSE, missing(thumbnail), ImageObject, thumbnail)
  self[["transcript"]] <- check_property("VideoObject", "transcript", FALSE, missing(transcript), "character", transcript)
  class(self) <- c(class(self), "VideoObject")
  self
}


#' Describes a volume mount from a host to container.
#'
#' @name VolumeMount
#' @param mountDestination The mount location inside the container. \bold{Required}.
#' @param alternateNames Alternate names (aliases) for the item.
#' @param description A description of the item.
#' @param id The identifier for this item.
#' @param identifiers Any kind of identifier for any kind of Thing.
#' @param images Images of the item.
#' @param meta Metadata associated with this item.
#' @param mountOptions A list of options to use when applying the mount.
#' @param mountSource The mount source directory on the host.
#' @param mountType The type of mount.
#' @param name The name of the item.
#' @param url The URL of the item.
#' @return A `list` of class `VolumeMount`
#' @seealso \code{\link{Thing}}
#' @export
VolumeMount <- function(
  mountDestination,
  alternateNames,
  description,
  id,
  identifiers,
  images,
  meta,
  mountOptions,
  mountSource,
  mountType,
  name,
  url
){
  self <- Thing(
    alternateNames = alternateNames,
    description = description,
    id = id,
    identifiers = identifiers,
    images = images,
    meta = meta,
    name = name,
    url = url
  )
  self$type <- as_scalar("VolumeMount")
  self[["mountDestination"]] <- check_property("VolumeMount", "mountDestination", TRUE, missing(mountDestination), "character", mountDestination)
  self[["mountOptions"]] <- check_property("VolumeMount", "mountOptions", FALSE, missing(mountOptions), Array("character"), mountOptions)
  self[["mountSource"]] <- check_property("VolumeMount", "mountSource", FALSE, missing(mountSource), "character", mountSource)
  self[["mountType"]] <- check_property("VolumeMount", "mountType", FALSE, missing(mountType), "character", mountType)
  class(self) <- c(class(self), "VolumeMount")
  self
}



#' Union type for valid block content.
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
BlockContent <- Union(CodeBlock, CodeChunk, Collection, Figure, Heading, List, ListItem, MathBlock, Paragraph, QuoteBlock, Table, ThematicBreak)


#' All type schemas that are derived from CodeBlock
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
CodeBlockTypes <- Union(CodeBlock, CodeChunk)


#' All type schemas that are derived from CodeFragment
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
CodeFragmentTypes <- Union(CodeFragment, CodeExpression)


#' All type schemas that are derived from Code
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
CodeTypes <- Union(Code, CodeBlock, CodeChunk, CodeExpression, CodeFragment)


#' All type schemas that are derived from ContactPoint
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
ContactPointTypes <- Union(ContactPoint, PostalAddress)


#' All type schemas that are derived from CreativeWork
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
CreativeWorkTypes <- Union(CreativeWork, Article, AudioObject, Collection, Comment, Datatable, Figure, ImageObject, MediaObject, Periodical, PublicationIssue, PublicationVolume, Review, SoftwareApplication, SoftwareSourceCode, Table, VideoObject)


#' All type schemas that are derived from Entity
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
EntityTypes <- Union(Entity, ArrayValidator, Article, AudioObject, BooleanValidator, Brand, Cite, CiteGroup, Code, CodeBlock, CodeChunk, CodeError, CodeExpression, CodeFragment, Collection, Comment, ConstantValidator, ContactPoint, CreativeWork, Datatable, DatatableColumn, Date, DefinedTerm, Delete, Emphasis, EnumValidator, Figure, Function, Grant, Heading, ImageObject, Include, IntegerValidator, Link, List, ListItem, Mark, Math, MathBlock, MathFragment, MediaObject, MonetaryGrant, NontextualAnnotation, NumberValidator, Organization, Paragraph, Parameter, Periodical, Person, PostalAddress, Product, PropertyValue, PublicationIssue, PublicationVolume, Quote, QuoteBlock, Review, SoftwareApplication, SoftwareEnvironment, SoftwareSession, SoftwareSourceCode, StringValidator, Strong, Subscript, Superscript, Table, TableCell, TableRow, ThematicBreak, Thing, TupleValidator, Variable, VideoObject, VolumeMount)


#' All type schemas that are derived from Grant
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
GrantTypes <- Union(Grant, MonetaryGrant)


#' Union type for valid inline content.
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
InlineContent <- Union(CodeFragment, CodeExpression, Delete, Emphasis, ImageObject, Link, MathFragment, NontextualAnnotation, Quote, Strong, Subscript, Superscript, Cite, CiteGroup, "numeric", "logical", "NULL", "character")


#' All type schemas that are derived from Mark
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
MarkTypes <- Union(Mark, Delete, Emphasis, NontextualAnnotation, Quote, Strong, Subscript, Superscript)


#' All type schemas that are derived from Math
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
MathTypes <- Union(Math, MathBlock, MathFragment)


#' All type schemas that are derived from MediaObject
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
MediaObjectTypes <- Union(MediaObject, AudioObject, ImageObject, VideoObject)


#' Union type for all valid nodes.
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
Node <- Union(Entity, "numeric", "logical", "NULL", "character", Array(Any()), "list")


#' All type schemas that are derived from NumberValidator
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
NumberValidatorTypes <- Union(NumberValidator, IntegerValidator)


#' All type schemas that are derived from Thing
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
ThingTypes <- Union(Thing, Article, AudioObject, Brand, Collection, Comment, ContactPoint, CreativeWork, Datatable, DatatableColumn, DefinedTerm, Figure, Grant, ImageObject, ListItem, MediaObject, MonetaryGrant, Organization, Periodical, Person, PostalAddress, Product, PropertyValue, PublicationIssue, PublicationVolume, Review, SoftwareApplication, SoftwareEnvironment, SoftwareSession, SoftwareSourceCode, Table, VideoObject, VolumeMount)


#' Union type for all validator types.
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
ValidatorTypes <- Union(ConstantValidator, EnumValidator, BooleanValidator, NumberValidator, IntegerValidator, StringValidator, ArrayValidator, TupleValidator)


#' All type schemas that are derived from Variable
#'
#' @return A `list` of class `Union` describing valid subtypes of this type
#' @export
VariableTypes <- Union(Variable, Parameter)


