% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupFuncs.R
\name{extract_observations}
\alias{extract_observations}
\title{Extract observations from data}
\usage{
extract_observations(
  data,
  groups,
  group_names = NULL,
  extract_mode = c("list", "data.frame"),
  strict_names = TRUE,
  simplify = FALSE,
  id
)
}
\arguments{
\item{data}{\emph{data.frame} from which to extract data}

\item{groups}{\emph{GroupAssignment} object on basis of which extract the data.}

\item{group_names}{\emph{character} vector of group names which to extract. If kept
as default \code{NULL}, all groups are extracted.}

\item{extract_mode}{\emph{character}: either \code{list} or \code{data.frame}. When kept as
default: \code{list}, data is extracted as named list: where the name of list is
name of the groups, and each one contains \emph{data.frame} with observations.
When \code{data.frame} is used, then assigned data is returned as one \emph{data.frame}
with new column named: \code{GroupAssignment}, declaring the group.}

\item{strict_names}{\emph{boolean} If \code{TRUE}, then intersected groups are extracted
using \emph{strict} strategy: \code{group_names} need to be provided in form: \code{"group1:group2"}. If
\code{FALSE}, then intersected groups will be taken into regard separately, so
eg. when \code{"group1"} is provided to \code{group_names}, all of: \code{"group1:group2"},
\code{"group1:group3"}, \code{"group1:groupN"}  will be extracted. Defaults to \code{TRUE}}

\item{simplify}{\emph{boolean} If \code{TRUE}, then when only one group is to be
returned, it returns as \code{data.frame} without taking into account value of
\code{group_name} argument. Defaults to \code{FALSE}}

\item{id}{If \emph{GroupAssignment} mode is \code{id}, and you want to overwrite the
original \code{id_col}, provide a name of the column there. If none is provided,
then the default \code{id_col} will be used.}
}
\value{
either:
\itemize{
\item \emph{named list} of \emph{data.frames} if \code{extract_mode = 'list'}
\item \emph{data.frame} if \code{extract_mode = 'data.frame'} or if only one group is to be
returned and \code{simplify = TRUE}
}
}
\description{
On basis of \emph{GroupAssignment} extract one or many groups from
provided data.frame
}
\examples{
#### Create Group Conditions ####
sex_grouping <- GroupConditions(
  conditions_category = "Sex",
  "M" ~ sex == "M",
  "F" ~ sex == "F",
  "O" ~ !sex \%in\% c("M", "F")
)

age_grouping <- GroupConditions(
  conditions_category = "Age",
  "to 20" ~ age < 20,
  "20 to 40" ~ age >= 20 & age <= 40,
  "41 to 60" ~ age > 40 & age <= 60,
  "above 60" ~ age > 60
)

#### Create Group Assignement ####
# can be done both with indices, so later this can be used only on the same data
# or with IDs - so later it can be done with only subset or transformed original data

sex_assignment <- GroupAssignment(HEXACO_60, sex_grouping, id = "user_id")
age_assignment <- GroupAssignment(HEXACO_60, age_grouping, id = "user_id")

#### Intersect two Group Assignement ###
# with additional forcing set
intersected <- intersect_GroupAssignment(
  sex_assignment,
  age_assignment,
  force_exhaustive = TRUE,
  force_disjoint = FALSE
)

extracted <- extract_observations(
  HEXACO_60,
  groups = intersected,
  group_names = c("M"),
  extract_mode = "data.frame",
  strict_names = FALSE)

# only groups created from "M" group were extracted
# groups without observations were dropped
table(extracted$GroupAssignment)
}
\seealso{
Other observation grouping functions: 
\code{\link{GroupAssignment}()},
\code{\link{intersect_GroupAssignment}()}
}
\concept{observation grouping functions}
