% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScoreTable.R
\name{ScoreTable}
\alias{ScoreTable}
\alias{print.ScoreTable}
\alias{plot.ScoreTable}
\title{Create a ScoreTable}
\usage{
ScoreTable(ft, scale)

\method{print}{ScoreTable}(x, ...)

\method{plot}{ScoreTable}(x, scale_name = NULL, ...)
}
\arguments{
\item{ft}{a \code{FrequencyTable} object}

\item{scale}{a \code{StandardScale} object or list of multiple \code{StandardScale} objects}

\item{x}{a \code{ScoreTable} object}

\item{...}{further arguments passed to or from other methods}

\item{scale_name}{if scores for multiple scales available, provide the name
of the scale for plotting.}
}
\value{
object of class \code{ScoreTable}. Consists of:
\itemize{
\item table: data.frame containing for each point in the raw score:
\itemize{
\item number of observations (\code{n}),
\item frequency in sample (\code{freq}),
\item quantile (\code{quan}),
\item normalized Z-score (\code{Z}),
\item score transformed to every of provided \code{StandardScales}
}
\item status: list containing the total number of simulated observations (\code{n})
and information about raw scores range completion (\code{range}): complete or incomplete
\item scale: named list of all attached \code{StandardScale} objects \
}
}
\description{
Creates a table to calculate scores in specified standardized
scale for each discrete raw score. Uses normalization provided by
\code{\link[=FrequencyTable]{FrequencyTable()}} and scale definition created with
\code{\link[=StandardScale]{StandardScale()}}.

After creation it can be used to normalize and standardize raw scores with
\code{\link[=normalize_score]{normalize_score()}} or \code{\link[=normalize_scores_df]{normalize_scores_df()}}.

\code{\link[=plot.ScoreTable]{plot.ScoreTable()}} method requires \code{ggplot2} package to be installed.
}
\examples{
# firstly compute FrequencyTable for a variable
ft <- FrequencyTable(HEXACO_60$HEX_A)

# then create a ScoreTable
st <- ScoreTable(ft, STEN)

# ScoreTable is ready to use!
st
}
