% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stddiff_spark.R
\name{stddiff.category}
\alias{stddiff.category}
\title{Compute Standardized Differences for Categorical Variables (Spark)}
\usage{
stddiff.category(data, gcol, vcol, verbose = FALSE)
}
\arguments{
\item{data}{A Spark DataFrame (\code{tbl_spark}) containing the variables.}

\item{gcol}{Integer; column index of the binary grouping variable.}

\item{vcol}{Integer vector; column indices of the categorical variables to analyze.}

\item{verbose}{Logical; if TRUE, prints progress messages. Default is FALSE.}
}
\value{
A numeric matrix with one row per category level and columns:
\itemize{
\item \code{p.c}: Proportion in control group
\item \code{p.t}: Proportion in treatment group
\item \code{missing.c}: Number of missing values in control group (first row only)
\item \code{missing.t}: Number of missing values in treatment group (first row only)
\item \code{stddiff}: Standardized difference (first row only)
\item \code{stddiff.l}: Lower CI bound (first row only)
\item \code{stddiff.u}: Upper CI bound (first row only)
}

Row names are formatted as "variable_name level_name".
}
\description{
Calculates standardized differences for categorical variables using a Spark
DataFrame. Equivalent to \code{stddiff::stddiff.category} but operates on Spark data.
}
\details{
For categorical variables with K levels, the standardized difference is
computed using a multivariate approach that accounts for all K-1 levels
simultaneously (excluding the reference level). Category levels are sorted
lexicographically; the first level alphabetically serves as the reference.
}
\examples{
\dontshow{if (requireNamespace("sparklyr", quietly = TRUE) && interactive()) withAutoprint(\{ # examplesIf}
sc <- sparklyr::spark_connect(master = "local")

spark_df <- sparklyr::copy_to(sc, as.data.frame(Titanic))

result <- stddiff.category(
  data = spark_df,
  gcol = 4,   # column index of grouping variable
  vcol = c(1) # columns of categorical variables
)

sparklyr::spark_disconnect(sc)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{stddiff.binary}}, \code{\link{stddiff.numeric}}
}
