% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_custom.R
\name{tidy.std_custom}
\alias{tidy.std_custom}
\title{Provide tidy output from a std_custom object for use in downstream computations}
\usage{
\method{tidy}{std_custom}(x, ...)
}
\arguments{
\item{x}{An object of class std_custom}

\item{...}{Not currently used}
}
\value{
A data.frame
}
\description{
Tidy summarizes information about the components of the standardized regression fit.
}
\examples{
set.seed(6)
n <- 100
Z <- rnorm(n)
X <- rnorm(n, mean = Z)
Y <- rbinom(n, 1, prob = (1 + exp(X + Z))^(-1))
dd <- data.frame(Z, X, Y)
prob_predict.glm <- function(...) predict.glm(..., type = "response")

x <- standardize(
  fitter = "glm",
  arguments = list(
    formula = Y ~ X * Z,
    family = "binomial"
  ),
  predict_fun = prob_predict.glm,
  data = dd,
  values = list(X = seq(-1, 1, 0.1)),
  B = 100,
  reference = 0,
  contrasts = "difference"
)
tidy(x)

}
