% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{.check_size}
\alias{.check_size}
\title{Check the size of an object}
\usage{
.check_size(x, min_size, max_size, x_arg = caller_arg(x), call = caller_env())
}
\arguments{
\item{x}{The object to check.}

\item{min_size}{\verb{(length-1 integer)} The minimum size of the object. Object
size will be tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{max_size}{\verb{(length-1 integer)} The maximum size of the object. Object
size will be tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}
}
\value{
\code{NULL}, invisibly, if \code{x} passes the check.
}
\description{
Checks if the size of \code{x} (from \code{\link[vctrs:vec_size]{vctrs::vec_size()}}) is within the bounds of
\code{min_size} and \code{max_size}.
}
\keyword{internal}
