% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cassay.R
\name{cassay}
\alias{cassay}
\title{Clinical Assay}
\usage{
cassay(n, mean = 0, sigma = 1, coefvar = NULL,
        d.cohen = NULL, dec = 2)
}
\arguments{
\item{n}{size of samples.}

\item{mean}{sample mean. Same for both groups before intervention (Pre-test).}

\item{sigma}{sample standard error.}

\item{coefvar}{sample coefficient of variation.}

\item{d.cohen}{size effect (d-Cohen). If not given, randomly generated.}

\item{dec}{number of decimals for observations.}
}
\value{
List containing the following components:
\itemize{

\item \code{Data}: a data frame containing the samples created (Columns: Group, PreTest & PostTest).

\item \code{Model}: linear regression model.
}
}
\description{
Simulates a clinical Assay with 2 groups (control and treatment) before and after intervention.
}
\examples{
cassay(c(10,12), mean = 115, sigma = 7.5, d.cohen= 1.5)
cassay(24, mean = 100, sigma = 5.1)

}
