% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{pi.score2}
\alias{pi.score2}
\title{Prediction interval for a difference of scores in a 2-group experiment}
\usage{
pi.score2(alpha, m1, m2, sd1, sd2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{estamated mean for group 1}

\item{m2}{estimated mean for group 1}

\item{sd1}{estimated standard deviation for group 1}

\item{sd2}{estimated standard deviation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 2-row matrix. The columns are:
\itemize{
\item Predicted - predicted difference in scores
\item df - degrees of freedom
\item LL - lower limit of the prediction interval
\item UL - upper limit of the prediction interval
}
}
\description{
For a 2-group experimental design, this function computes a prediction
interval for how the response variable score for one randomly selected
person from the study population would differ under the two treatment
conditions. Both equal variance and unequal variance prediction intervals
are computed.

For more details, see Section 2.6 of Bonett (2021, Volume 1)
}
\examples{
pi.score2(.05, 19.4, 11.3, 2.70, 2.10, 40, 40)

# Should return:
#                              Predicted    df       LL       UL
# Equal Variances Assumed:           8.1 78.00 1.205659 14.99434
# Equal Variances Not Assumed:       8.1 73.54 1.199073 15.00093
 

}
\references{
\insertRef{Hahn1977}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
