% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.sd}
\alias{ci.sd}
\title{Confidence interval for a standard deviation}
\usage{
ci.sd(alpha, sd, n)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence}

\item{sd}{estimated standard deviation}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated standard deviation (from input)
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the traditional confidence interval for a population standard
deviation using a sample estimate of the standard deviation. The traditional
confidence interval assumes normality and is hypersensitive to minor
violations of this assumption. This function should be used only if the
data appear to come from an approximate normal or mildly platykurtic
distribution.
}
\examples{
ci.sd(.05, 4.65, 50)

# Should return:
#  Estimate       LL       UL
#      4.65 3.884303  5.79452
 

}
