% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_sevt.R
\name{random_sevt}
\alias{random_sevt}
\alias{random_sevt.list}
\alias{random_sevt.parentslist}
\alias{random_sevt.sevt}
\title{Generate a random (fitted) sevt}
\usage{
random_sevt(x, q = 0.5, rfun = rexp)

\method{random_sevt}{list}(x, q = 0.5, rfun = rexp)

\method{random_sevt}{parentslist}(x, q = 0.5, rfun = rexp)

\method{random_sevt}{sevt}(x, q = 0.5, rfun = rexp)
}
\arguments{
\item{x}{a \code{sevt} object, a \code{parentslist} object or a
\code{list}.}

\item{q}{probability of joining stages.}

\item{rfun}{a function which is used to generate random
conditional probabilities associated to each stage.}
}
\value{
A randomly generated fitted \code{sevt} object.
}
\description{
Generate a random \code{sevt} from a DAG or a tree.
Probabilities are also randomly generated.
}
\details{
The generated staged tree is obtained by randomly
joining stages with probability \code{q}.

For \code{random_sevt.list}, \code{x} should be
a list representing an event tree, same format
as lists provided to \code{\link{sevt.list}}.
The random generated \code{sevt} will be
obtained by randomly joining stages starting from
a full staged event tree.

For \code{random_sevt.parentslist}, \code{x} should be
a \code{\link[=as_parentslist]{parentslist}} object
representing a DAG, this could be obtained with
\code{\link{as_parentslist}} or with
\code{\link{random_parentslist}}.
The random generated \code{sevt} will be
obtained by randomly joining stages starting from
a the staged tree equivalent to the DAG.

For \code{random_sevt.sevt}, \code{x} should be
a \code{\link{sevt}}.
The random generated \code{sevt} will be
obtained by randomly joining stages starting
from the provided sevt object.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     Stages (conditional) probabilities are sampled from
     the corresponding probability simplex by generating
     a vector with the user-defined function \code{rfun} and
     normalizing it to sum up to one.
     Absolute value is applied to assure non-negativity.
     The default \code{rfun = rexp} induces a uniform sampling
     from the probability simplex.
}\if{html}{\out{</div>}}
}
\examples{
model_gt <- random_sevt(list(
  X = c("a", "b"), Y = c("c", "d", "e"),
  Z = c("1", "2", "3"), W = c("yes", "no")
))

## sample data from model_gt and estimate a staged tree
data <- sample_from(model_gt, 100)
model_est <- stages_bhc(full(data))

## compare true and estimated model
hamming_stages(model_gt, model_est)
compare_stages(model_gt, model_est, method = "hamming", plot = TRUE)
}
