% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_parentslist.R
\name{random_parentslist}
\alias{random_parentslist}
\title{Generate a random \code{parentslist} object (DAG)}
\usage{
random_parentslist(n, k = 2, maxp = n)
}
\arguments{
\item{n}{number of variables.}

\item{k}{maximum number of levels for each variable.}

\item{maxp}{maximum cardinality of parents sets.}
}
\value{
a \code{\link[=as_parentslist]{parentslist}} object.
}
\description{
generate a random DAG coded as
\code{\link[=as_parentslist]{parentslist}} object.
}
\details{
For each variable a subset of random cardinality
(maximum \code{maxp}) of the preceding
variables is randomly selected as parents set.
The possible levels of each variables are randomly selected
in \code{2,...,k}.
}
\examples{
random_parentslist(5, 3, 2)

## we can generate the associated staged tree
pl <- random_parentslist(4, 2, 2)
plot(as_sevt(pl), main = as.character(pl))
}
