% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability.R
\name{prob}
\alias{prob}
\title{Probabilities for a staged event tree}
\usage{
prob(object, x, conditional_on = NULL, log = FALSE, na0 = TRUE)
}
\arguments{
\item{object}{an object of class \code{sevt} with probabilities.}

\item{x}{the vector or data.frame of observations.}

\item{conditional_on}{named vector, the conditioning event.}

\item{log}{logical, if \code{TRUE} log-probabilities are returned.}

\item{na0}{logical, if \code{NA} should be converted to 0.}
}
\value{
the probabilities to observe each observation in \code{x}, possibly
conditional on the event(s) in \code{conditional_on}.
}
\description{
Compute (marginal and/or conditional) probabilities of elementary
events with respect
to the probability encoded in a staged event tree.
}
\details{
Computes probabilities related to a vector or a
data.frame of observations.

Optionally, conditional probabilities can be obtained by specifying
the conditioning event in \code{conditional_on}. This can be done either
with a single named vector or with a data.frame object with the
same number of rows of \code{x}. In the former, the same conditioning
is used for all the computed probabilities (if \code{x} has multiple rows);
while with the latter different conditioning events (but on the same variables)
can be specified for each row of \code{x}.
}
\examples{
data(Titanic)
model <- full(Titanic, lambda = 1)
samples <- expand.grid(model$tree[c(1, 4)])
pr <- prob(model, samples)
## probabilities sum up to one
sum(pr)
## print observations with probabilities
print(cbind(samples, probability = pr))

## compute one probability
prob(model, c(Class = "1st", Survived = "Yes"))

## compute conditional probability
prob(model, c(Survived = "Yes"), conditional_on = c(Class = "1st"))

## compute conditional probabilities with different conditioning set
prob(model, data.frame(Age = rep("Adult", 8)),
  conditional_on = expand.grid(model$tree[2:1])
)
## the above should be the same as
summary(model)$stages.info$Age
}
