% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackgbm.R
\name{stackgbm}
\alias{stackgbm}
\title{Model stacking for boosted trees}
\usage{
stackgbm(x, y, params, n_folds = 5L, seed = 42, verbose = TRUE)
}
\arguments{
\item{x}{Predictor matrix.}

\item{y}{Response vector.}

\item{params}{A list of optimal parameter objects for boosted tree models
derived from \code{\link[=cv_xgboost]{cv_xgboost()}}, \code{\link[=cv_lightgbm]{cv_lightgbm()}}, and \code{\link[=cv_catboost]{cv_catboost()}}.
The order does not matter.}

\item{n_folds}{Number of folds. Default is 5.}

\item{seed}{Random seed for reproducibility.}

\item{verbose}{Show progress?}
}
\value{
Fitted boosted tree models and stacked tree model.
}
\description{
Model stacking with a two-layer architecture: first layer being boosted
tree models fitted by xgboost, lightgbm, and catboost; second layer being
a logistic regression model.
}
\examples{
\dontshow{if (is_installed_xgboost() && is_installed_lightgbm() && is_installed_catboost()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sim_data <- msaenet::msaenet.sim.binomial(
  n = 1000,
  p = 50,
  rho = 0.6,
  coef = rnorm(25, mean = 0, sd = 10),
  snr = 1,
  p.train = 0.8,
  seed = 42
)

params_xgboost <- structure(
  list("nrounds" = 200, "eta" = 0.05, "max_depth" = 3),
  class = c("cv_params", "cv_xgboost")
)
params_lightgbm <- structure(
  list("num_iterations" = 200, "max_depth" = 3, "learning_rate" = 0.05),
  class = c("cv_params", "cv_lightgbm")
)
params_catboost <- structure(
  list("iterations" = 100, "depth" = 3),
  class = c("cv_params", "cv_catboost")
)

fit <- stackgbm(
  sim_data$x.tr,
  sim_data$y.tr,
  params = list(
    params_xgboost,
    params_lightgbm,
    params_catboost
  )
)

predict(fit, newx = sim_data$x.te)
\dontshow{\}) # examplesIf}
}
