% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stab_par.R
\name{stab_par}
\alias{stab_par}
\alias{stab_par.default}
\title{Stability Parameters for Genotypes by Environment Interaction (GEI)}
\usage{
stab_par(.data, .y, .rep, .gen, .env, alpha = 0.1, .envCov = NULL)

\method{stab_par}{default}(.data, .y, .rep, .gen, .env, alpha = 0.1, .envCov = NULL)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.rep}{Replication Factor}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}

\item{alpha}{Level of Significance, default is 0.1}

\item{.envCov}{Environmental Covariate, default is NULL}
}
\value{
Stability Parameters
}
\description{
Stability Parameters for Genotypes by Environment Interaction (GEI)
}
\examples{

data(ge_data)
Yield.StabPar <-
   stab_par(
            .data   = ge_data
          , .y      = Yield
          , .rep    = Rep
          , .gen    = Gen
          , .env    = Env
          , alpha   = 0.1
          , .envCov = NULL
)

Yield.StabPar

}
\references{
Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Kent M. Edkridge (\email{keskridge1@unl.edu})
         }
}
