% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{split_train_test}
\alias{split_train_test}
\title{Splits a data frame into train and test sets.}
\usage{
split_train_test(df, pctTrain)
}
\arguments{
\item{df}{a data frame.}

\item{pctTrain}{numeric value that specifies the percentage of rows to be included in the train set. The remaining rows are added to the test set.}
}
\value{
a list with the first element being the train set and the second element the test set.
}
\description{
Utility function to randomly split a data frame into train and test sets.
}
\examples{
set.seed(1234)

dataset <- friedman1

nrow(dataset) # print number of rows

split1 <- split_train_test(dataset, pctTrain = 70) # select 70\% for training

nrow(split1$trainset) # number of rows of the train set

nrow(split1$testset) # number of rows of the test set

head(split1$trainset) # display first rows of train set

}
