% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sshin.R
\name{sshin}
\alias{sshin}
\title{Measurement of Spatial Stratified Heterogeneity Based on Information Consistency for Nominal Variables}
\usage{
sshin(d, s, seed = 42, permutation_number = 999)
}
\arguments{
\item{d}{The target variable.}

\item{s}{The stratification.}

\item{seed}{(optional) Random number seed, default is \code{42}.}

\item{permutation_number}{(optional) Number of Random Permutations, default is \code{999}.}
}
\value{
A two-element numerical vector.
}
\description{
Measurement of Spatial Stratified Heterogeneity Based on Information Consistency for Nominal Variables
}
\examples{
\donttest{
# This code may take a bit longer to execute:
cinc = sf::read_sf(system.file("extdata/cinc.gpkg",package = "sshicm"))
sshin(cinc$THEFT_D,cinc$MALE)
}
}
