% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sshicm.R
\name{sshicm}
\alias{sshicm}
\title{Information Consistency-Based Measures for Spatial Stratified Heterogeneity}
\usage{
sshicm(
  formula,
  data,
  type = "IC",
  seed = 42,
  permutation_number = 999,
  bin_method = "Sturges"
)
}
\arguments{
\item{formula}{A formula.}

\item{data}{A \code{data.frame}, \code{tibble} or \code{sf} object of observation data.}

\item{type}{(optional) Measure type, default is \code{IC}.}

\item{seed}{(optional) Random number seed, default is \code{42}.}

\item{permutation_number}{(optional) Number of Random Permutations, default is \code{999}.}

\item{bin_method}{(optional) Histogram binning method for probability density estimation, default is
\code{Sturges}.}
}
\value{
A \code{tibble}.
}
\description{
Information Consistency-Based Measures for Spatial Stratified Heterogeneity
}
\examples{
\donttest{
# This code may take a bit longer to execute:
baltim = sf::read_sf(system.file("extdata/baltim.gpkg",package = "sshicm"))
sshicm(PRICE ~ .,baltim,type = "IC")
cinc = sf::read_sf(system.file("extdata/cinc.gpkg",package = "sshicm"))
sshicm(THEFT_D ~ .,cinc,type = "IN")
}
}
