% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{compute_sample_size}
\alias{compute_sample_size}
\title{Compute sample size}
\usage{
compute_sample_size(means = NULL, sds = NULL, proportions = NULL,
  N = Inf, power = 0.8, sig.level = 0.05, ties = 0.5,
  .verbose = FALSE, ...)
}
\arguments{
\item{means}{A vector of length 2 containing the (assumed) means of the two groups}

\item{sds}{A vector containing the (assumed) standard deviations of the two groups. 
When only one element is supplied equal variances are assumed.}

\item{proportions}{A vector of length 2 containing the (assumed) proportions of the two groups}

\item{N}{Estimated population size}

\item{power}{Desired power for the classical RCT}

\item{sig.level}{Significance level of the test used (alpha)}

\item{ties}{Probability of choosing the first group in case of a tie (i.e., H0 is not rejected)}

\item{.verbose}{Whether or not verbose output should be provided, default FALSE}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of type ssev
}
\description{
Function to compute the optimal sample size for a comparison of two  means
(with equal or unequal variances) or proportions. Function returns the standard
sample size for an RCT with the specified power, as well as the optimal sample size
for a population of size N.
}
\examples{
compute_sample_size(means=c(0,1), sds=2, N=100)
compute_sample_size(means=c(0,1), sds=2, N=10000, power=.9)
compute_sample_size(means=c(0,1), sds=c(1,2), N=10000)
compute_sample_size(proportions=c(.5,.7), N=5000)
}
