% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_ssm.R
\name{run_ssm}
\alias{run_ssm}
\title{State-space modeling of mouse-tracking trajectories via Stan}
\usage{
run_ssm(
  N,
  I,
  J,
  Y = NULL,
  D = NULL,
  Z = NULL,
  sigmax = 1,
  lambda = 1,
  y_T = pi/4,
  y_D = (3 * pi)/4,
  priors = "default",
  gfunction = c("logistic", "gompertz"),
  kappa_bnds = c(5, 300),
  nchains = 1,
  niter = 2000,
  nwarmup = 500,
  ncores = "AUTO",
  stan_object = FALSE,
  ...
)
}
\arguments{
\item{N}{(integer) length of the Y-trajectories}

\item{I}{(integer) number of individuals}

\item{J}{(integer) number of trials}

\item{Y}{(matrix) N x JI matrix of observed trajectories}

\item{D}{(matrix) N x JI matrix of delta values for the observed trajectories}

\item{Z}{(matrix) matrix of contrasts associated to the experimental design (see \code{\link{generate_design}})}

\item{sigmax}{(numeric) fixed value for the model parameter sigmax}

\item{lambda}{(numeric) fixed value for the model parameter lambda}

\item{y_T}{(numeric) position in angles of the target}

\item{y_D}{(numeric) position in angles of the distractor}

\item{priors}{(list) a list of arguments specifying priors for each parameter involved in the model (see \code{\link{check_prior}}). If \code{priors="default"} then pre-defined tpriors will be used.}

\item{gfunction}{(character) type of link function between latent states and observed data: 'logistic', 'gompertz' (\code{default = 'logistic'}).}

\item{kappa_bnds}{(array) array containing the lower and upper bounds for the kappa parameter (\code{default = c(5,300)})}

\item{nchains}{(integer) number of chains for the MCMC algorithm}

\item{niter}{(integer) number of iterations for each chain}

\item{nwarmup}{(integer) number of warmup/burnin iterations per chain}

\item{ncores}{(integer) number of cores to use when executing the chains in parallel. The default option ncores="AUTO" will automatically determine the number of cores via the \code{parallel} package}

\item{stan_object}{(boolean) if \code{stan_object=TRUE}, the object of S4 class stanfit representing the fitted results will be saved as stan_object.rda}

\item{...}{other stan arguments (e.g., 'init', 'algorithm', 'sample_file'. See \code{\link[rstan:sampling]{sampling}})}
}
\value{
a datalist containing the posterior samples for the model parameters along with the main Stan output
}
\description{
State-space modeling of mouse-tracking trajectories via Stan
}
\details{
The function drawns samples from the posterior distribution of the model parameters. Note that, the current version of \pkg{ssMousetrack} package requires the number of stimuli J to be the same over the subjects \eqn{i=1,...,I}.
}
\examples{

\dontrun{
## Fit a state-space model using simulated data 
# Generate mouse-tracking data for an univariate experimental design with K = 3 categorical levels, 
# J = 12 trials, I = 5 subjects
X1 <- generate_data(I=5,J=12,K=3,Z.formula="~Z1")
iid <- 23 # keep just one dataset from the simulated set of datasets
# Run the state-space model on the chosen dataset
X1_fit <- run_ssm(N = X1$N,I = X1$I,J = X1$J,Y = X1$data$Y[iid,,],D = X1$data$D[iid,,],
Z = X1$data$Z)

## Fit a state-space model using the experimental dataset language
# The dataset is ready to be used and it does not need to be pre-processed (preprocess=FALSE). 
# In this case, the function prepare_data just computes the observed radians from 
# the x-y trajectories
X2 <- prepare_data(X = language, preprocess = FALSE, Z.formula = "~condition")
# Run the state-space model on the chosen dataset
X2_fit <- run_ssm(N = X2$N,I = X2$I,J = X2$J,Y = X2$Y,D = X2$D,Z = X2$Z,
niter=5000,nchains=2)

## Fit a state-space model using the experimental dataset congruency
# The dataset needs to be pre-processed (preprocess=TRUE)
X3 <- prepare_data(X = congruency, preprocess = TRUE, 
Z.formula = "~congruency+plausibility") # additive design
# Define priors of the model parameters 
KK <- dim(X3$Z)[2] # number of model parameters implied by the design matrix Z
priors_list <- list("lognormal(1,0.5)","pareto(3,5.25)","normal(0,2.5)")
# note that length(priors_list) = KK 
# Run the state-space model on the chosen dataset
X3_fit <- run_ssm(N = X3$N,I = X3$I,J = X3$J,Y = X3$Y,D = X3$D,Z = X3$Z,
niter=10000,nwarmup=3500,priors=priors_list,nchains=4)
}
}
