% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_f.r
\name{change_f}
\alias{change_f}
\title{Alter fishing mortality (\emph{F}) using the SS control file}
\usage{
change_f(years, fisheries, fvals, seasons = 1, ses = 0.005,
  ctl_file_in, ctl_file_out = "control_fishing.ss")
}
\arguments{
\item{years}{*Vector of integers that will map to each \code{fvals}
specifying which year the fishing level pertains to.}

\item{fisheries}{*Vector of integers that will map to each \code{fvals}
specifying which fleet the fishing level pertains to.
A single value will be repeated for every value in \code{years} or
\code{length(years) == length(fisheries)} must be true.}

\item{fvals}{*Vector of \emph{F} values to be entered into the
SS control file. A single value will be repeated for every value in \code{years} or
\code{length(years) == length(fvals)} must be true.}

\item{seasons}{Vector of seasons to be entered into the
SS control file. A single value will be repeated for every value in \code{years} or
\code{length(years) == length(ses)} must be true.
The default is 1, which will be applied to all fisheries in all years.}

\item{ses}{Vector of fishing level standard errors (ses) to be entered into the
SS control file. A single value will be repeated for every value in \code{years} or
\code{length(years) == length(ses)} must be true.
The default is 0.005, which will be applied to all fisheries in all years.}

\item{ctl_file_in}{A string providing the path to the input SS \code{.ctl} file.}

\item{ctl_file_out}{A string providing the path to the output SS control file. If the value is \code{NULL}, the file will not be written to the disk.}
}
\value{
Modified SS control file.
}
\description{
Alter fishing mortality (\emph{F}) for a Stock Synthesis simulation
via changes to the control file. The argument \code{years} is the only
argument that must be a vector, where other vectors, e.g., \code{fisheries},
will be repeated if a single value is provided.
}
\details{
Using the control file depends on
(1) the starter file is set up to read parameters from the control file
rather than the par file and
(2) the data file having a dummy catch entry for every year, fishery
combination that will be specified in the control file.
\emph{F} values currently in the control file will be removed and
the newly specified values will replace them.
Users do not need to specify values for years in which there
will be zero fishing because SS will be parameterized to assume
no fishing in missing years.

The control file is currently read in using \code{readLines} but will
eventually shift to using code specific to Stock Synthesis to alter
a structured list.
If used with \code{\link{run_ss3sim}}, the case file should be named
\code{F}. A suggested (default) case letter is \code{F}.
}
\section{Which arguments to specifiy in case files}{

All function argument descriptions that start with an asterisk (*) will be passed
through the case files to \code{\link{run_ss3sim}}. If one of these arguments
is not specified in a case file, then a value of \code{NULL} will be passed,
which may or may not be an appropriate value. Other arguments will be ignored
if specified.
}

\examples{
d <- system.file(file.path("extdata", "models"), package = "ss3sim")
change_f(years = 1:50, fisheries = 1, fvals = 0.2,
  ctl_file_in = file.path(d, "cod-om", "codOM.ctl"),
  ctl_file_out = file.path(tempdir(), "control_fishing.ss"))
}
\seealso{
Other change functions: \code{\link{change_data}},
  \code{\link{change_em_binning}}, \code{\link{change_e}},
  \code{\link{change_f_par}}, \code{\link{change_o}},
  \code{\link{change_retro}}, \code{\link{change_tv}}
}
\author{
Kelli Faye Johnson
}
\concept{change functions}
