% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-class.R
\name{autoplot.qts}
\alias{autoplot.qts}
\title{Plot for \code{\link{qts}} objects}
\usage{
\method{autoplot}{qts}(object, highlighted_points = NULL, ...)
}
\arguments{
\item{object}{An object of class \link{qts}.}

\item{highlighted_points}{An integer vector specifying point indices to be
highlighted. Defaults to \code{NULL}, in which case no point will be highlighted
with respect to the others.}

\item{...}{Further arguments to be passed on to next methods.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
This function creates a visualization of a QTS and returns the corresponding
\link[ggplot2:ggplot]{ggplot2::ggplot} object which enable further customization of the plot.
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}
ggplot2::autoplot(vespa64$igp[[1]])
\dontshow{\}) # examplesIf}
}
