% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_connection_args.R
\name{db_connection_args}
\alias{db_connection_args}
\title{Build SQL Server connection arguments}
\usage{
db_connection_args(
  server,
  database,
  uid = NULL,
  pwd = NULL,
  port = NULL,
  trusted = TRUE,
  driver = "ODBC Driver 17 for SQL Server"
)
}
\arguments{
\item{server}{SQL Server hostname, IP address, or instance name}

\item{database}{Database name}

\item{uid}{Username (ignore/keep as NULL if trusted = TRUE)}

\item{pwd}{Password (ignore/keep as NULL if trusted = TRUE)}

\item{port}{Optional port number. If NULL, odbc package handles port resolution}

\item{trusted}{(logical) If TRUE (default), uses Windows authentication}

\item{driver}{ODBC driver name (default is "ODBC Driver 17 for SQL Server")}
}
\value{
A named list of arguments suitable for a SQL Server connection
string in DBI::dbConnect() or pool::dbPool(). Used internally by
\code{db_connect()} to construct the argument list.
}
\description{
Build SQL Server connection arguments
}
\examples{
# Build arguments using Windows authentication
db_connection_args(
  server   = "localhost",
  database = "master"
)

# Build arguments using SQL authentication
db_connection_args(
  server   = "localhost",
  database = "master",
  uid      = "sa",
  pwd      = "password",
  trusted  = FALSE
)

}
