testthat::context("ExprFieldDef class")

testthat::test_that("Initializer works fine", {
  testthat::expect_error(ExprFieldDef$new())
  testthat::expect_error(ExprFieldDef$new("a"))
  ExprFieldDef$new("a", "integer")
})

testthat::test_that("Conversion to string works fine", {
  testthat::expect_equal(ExprFieldDef$new("a", "integer")$toString(),
                         "a INTEGER")
  testthat::expect_equal(ExprFieldDef$new("a", "integer",
                                          primary = TRUE)$toString(),
                         "a INTEGER PRIMARY KEY")
  testthat::expect_equal(ExprFieldDef$new("a", "integer",
                                          nullable = FALSE)$toString(),
                         "a INTEGER NOT NULL")
})
