% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factories.R
\name{make_join}
\alias{make_join}
\title{Create a SQL JOIN statement.}
\usage{
make_join(
  field1,
  table1,
  field2,
  table2 = NULL,
  type = c("inner", "left", "right", "full")
)
}
\arguments{
\item{field1}{The first field on which to join.}

\item{table1}{The table name of the first field.}

\item{field2}{The second field on which to join.}

\item{table2}{The table name of the second field (optional).}

\item{type}{The type of join to perform. One of "inner", "left", "right", or
"full". Defaults to "inner".}
}
\value{
An instance of StmtJoin.
}
\description{
Create a StmtJoin instance.
}
\examples{
# To generate a JOIN statement joining the "author_id" field of the "books"
# table with the "id" field of the "authors" table:
join <- make_join("author_id", "books", "id", "authors")

}
