% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StmtSelectFields.R
\name{StmtSelectFields}
\alias{StmtSelectFields}
\title{SELECT fields statement.}
\description{
SELECT fields statement.

SELECT fields statement.
}
\details{
This class represents a SQL SELECT statement with specific fields. It
requires a list of \code{ExprField} instances representing the fields to select,
with optional \code{distinct} keyword to remove duplicate results.
}
\examples{
# Create a SELECT statement with specific fields:
field1 <- ExprField$new("title", "books")
field2 <- ExprField$new("name", "authors")
select_fields <- StmtSelectFields$new(fields = list(field1, field2))

# Use the created SELECT statement inside a SELECT query:
query <- QuerySelect$new(select = select_fields,
                         from = StmtFrom$new("books"))

}
\section{Super classes}{
\code{\link[sqlq:Statement]{sqlq::Statement}} -> \code{\link[sqlq:StmtSelect]{sqlq::StmtSelect}} -> \code{StmtSelectFields}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StmtSelectFields-new}{\code{StmtSelectFields$new()}}
\item \href{#method-StmtSelectFields-getTokens}{\code{StmtSelectFields$getTokens()}}
\item \href{#method-StmtSelectFields-clone}{\code{StmtSelectFields$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sqlq" data-topic="Statement" data-id="toString"><a href='../../sqlq/html/Statement.html#method-Statement-toString'><code>sqlq::Statement$toString()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtSelectFields-new"></a>}}
\if{latex}{\out{\hypertarget{method-StmtSelectFields-new}{}}}
\subsection{Method \code{new()}}{
Initializer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtSelectFields$new(fields, distinct = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{A list of ExprField instances.}

\item{\code{distinct}}{Set to TRUE enable \code{distinct} keyword and remove
duplicate results.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtSelectFields-getTokens"></a>}}
\if{latex}{\out{\hypertarget{method-StmtSelectFields-getTokens}{}}}
\subsection{Method \code{getTokens()}}{
Generates the list of tokens representing this statement.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtSelectFields$getTokens()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of Token objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtSelectFields-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StmtSelectFields-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtSelectFields$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
