% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_default_conn_name.R
\name{set_default_conn_name}
\alias{set_default_conn_name}
\alias{get_default_conn_name}
\title{Set/get the name of the default connection to use}
\usage{
set_default_conn_name(conn_name)

get_default_conn_name()
}
\arguments{
\item{conn_name}{Character string. The name a connection}
}
\value{
\code{get} returns the name of the default connection;
\code{set} returns \code{NULL}, invisibly.
}
\description{
Set/get the name of the default connection to use
}
\examples{
library(sqlhelper)
connect(
    system.file("examples/sqlhelper_db_conf.yml",
                package="sqlhelper"),
    exclusive = TRUE
)

connection_info()

get_default_conn_name()

set_default_conn_name("pool_sqlite")

connection_info()

get_default_conn_name()

}
