% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils2.R
\name{extract.spbp}
\alias{extract.spbp}
\title{Extract method for fitted spbp models}
\usage{
\method{extract}{spbp}(spbp, pars = c("beta", "gamma"), ...)
}
\arguments{
\item{spbp}{an object of class `spbp` result of a \code{\link[spsurv]{spbp}} fit.}

\item{pars}{parameters to be selected.}

\item{...}{arguments inherent from \code{\link[rstan]{extract}}.}
}
\value{
see \code{\link[rstan]{extract}}.
}
\description{
Extract samples from a fitted \code{\link[spsurv]{spbp}} model.
}
\examples{

library("spsurv")
data("veteran")

fit <- bpph(Surv(time, status) ~ karno + factor(celltype),
data = veteran)

extract(fit)

}
\seealso{
\code{\link[spsurv]{spbp}}, \code{\link[spsurv]{stan_dens.spbp}}, \code{\link[spsurv]{traceplot.spbp}}
}
