% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLASS_seq_ttest_results.R
\docType{class}
\name{seq_ttest_results-class}
\alias{seq_ttest_results-class}
\title{An S4 class to represent the results of a sequential t-test.}
\description{
An S4 class to represent the results of a sequential t-test.
}
\section{Slots}{

\describe{
\item{\code{likelihood_ratio_log}}{the logarithmic test statistic.}

\item{\code{decision}}{the test decision: "accept H1", "accept H0",
or "continue sampling".}

\item{\code{A_boundary_log}}{the lower logarithmic boundary of the test.}

\item{\code{B_boundary_log}}{the upper logarithmic boundary of the test.}

\item{\code{d}}{a number indicating the specified effect size (Cohen's d).}

\item{\code{mu}}{a number indicating the true value of the mean
(or difference in means if you are performing a two sample test).}

\item{\code{alpha}}{the type I error. A number between 0 and 1.}

\item{\code{power}}{1 - beta (beta is the type II error probability). A number
between 0 and 1.}

\item{\code{likelihood_ratio}}{the likelihood ratio of the test without logarithm.}

\item{\code{likelihood_1}}{the likelihood of the alternative Hypothesis (H1).}

\item{\code{likelihood_0}}{the likelihood of the null Hypothesis (H0).}

\item{\code{likelihood_1_log}}{the logarithmic likelihood of the alternative
Hypothesis (H1).}

\item{\code{likelihood_0_log}}{the logarithmic likelihood of the null
Hypothesis (H0).}

\item{\code{non_centrality_parameter}}{parameter to calculate the likelihoods}

\item{\code{t_value}}{the t-value of the t-statistic.}

\item{\code{p_value}}{the p-value of the t-test.}

\item{\code{df}}{degrees of freedom.}

\item{\code{mean_estimate}}{the estimated mean or difference in means depending on
whether it was a one-sample test or a two-sample test.}

\item{\code{alternative}}{a character string specifying the alternative hypothesis:
"two.sided" (default), "greater" or "less".}

\item{\code{one_sample}}{"true" if it is a one-sample test, "false" if it is a
two-sample test.}

\item{\code{ttest_method}}{a character string indicating what type of t-test was
performed.}

\item{\code{data_name}}{a character string giving the name(s) of the data.}

\item{\code{verbose}}{a logical value whether you want a verbose output or not.}
}}

\keyword{internal}
