% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sprt.R
\name{plot_anova}
\alias{plot_anova}
\title{Plot Sequential ANOVA Results}
\usage{
plot_anova(
  anova_results,
  labels = TRUE,
  position_labels_x = 0.15,
  position_labels_y = 0.075,
  position_lr_x = 0.05,
  font_size = 25,
  line_size = 1.5,
  highlight_color = "#CD2626"
)
}
\arguments{
\item{anova_results}{result object of the seq_anova() function (argument must be of class \code{seq_anova_results}).}

\item{labels}{show labels in the plot.}

\item{position_labels_x}{position of the boundary labels on the x-axis.}

\item{position_labels_y}{position of the boundary labels on the y-axis.}

\item{position_lr_x}{scales the position of the LR label on the x-axis.}

\item{font_size}{font size of the plot.}

\item{line_size}{line size of the plot.}

\item{highlight_color}{highlighting color, default is "#CD2626" (red).}
}
\value{
returns a plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Creates plots for the results of the seq_anova() function.
}
\examples{
# simulate data for the example ------------------------------------------------
set.seed(333)
data <- sprtt::draw_sample_normal(3, f = 0.25, max_n = 30)

# calculate the SPRT -----------------------------------------------------------
anova_results <- sprtt::seq_anova(y~x, f = 0.25, data = data, plot = TRUE)

# plot the results -------------------------------------------------------------
sprtt::plot_anova(anova_results)

sprtt::plot_anova(anova_results,
                 labels = TRUE,
                 position_labels_x = 0.5,
                 position_labels_y = 0.1,
                 position_lr_x = -0.5,
                 font_size = 25,
                 line_size = 2,
                 highlight_color = "green"
                 )

sprtt::plot_anova(anova_results,
                 labels = FALSE
                 )
}
